<?php
	session_start();

	if (!isset($_SESSION['__idUsu'])) {
    header("Location: ../frm_login.php");
    exit;
	}

	header('Content-Type: application/json; charset=utf-8');

	require_once('../includes/conexao.php');
	require('../includes/funcoes.php');
	require('../includes/configGoogle.php');

	// Tipo de validação cadastro ou consulta
	$tipo = isset($_POST["Tipo"]) ? (string) $_POST["Tipo"] : null;
	$idCad = isset($_POST['idCadastro']) ? (int) $_POST['idCadastro'] : null;
	$idCur = isset($_POST['Curso']) ? (int) $_POST['Curso'] : null;
	$captcha = $_POST['g-recaptcha-response'] ?? '';
	$remoteip = $_SERVER['REMOTE_ADDR'] ?? null;
	// --- Captura chaves ---
	$secret = Config::GOOGLE_RECAPTCHA_SECRET_KEY;
	$url = Config::GOOGLE_RECAPTCHA_VERIFY_URL;

	$recaptchaResponse = verificarRecaptcha($captcha, $remoteip, $secret, $url);

	if ($recaptchaResponse['success'] === false) {
		echo json_encode([
			"status" => false,
			"mensagem" => "Erro ao conectar com a API do Google."
		]);
		exit;
	}

	if ($recaptchaResponse['score'] < Config::GOOGLE_MIN_SCORE) {
		echo json_encode([
			"status" => false,
			"mensagem" => 'Pontuação reCAPTCHA muito baixa. Possível bot.'
		]);
		exit;
	}

	// Sanitização e normalização de dados
	$nome = trim($_POST['Nome'] ?? '');
	$matricula = trim($_POST['Matricula'] ?? '');
	$telResidencial = trim($_POST['TelResidencial'] ?? '');
	$telTrabalho = trim($_POST['TelTrabalho'] ?? '');
	$telCelular = trim($_POST['TelCelular'] ?? '');
	$email = fncConvTodasPalavraMinusculas($_POST['Email'] ?? '');
	$confirmarEmail = fncConvTodasPalavraMinusculas($_POST['ConfirmarEmail'] ?? '');
	$pais = fncConvPrimeiraPalavraMaiuscula($_POST['Pais'] ?? '');
	$endereco = fncAntiInjection($_POST['Endereco'] ?? '');
	$complemento = fncAntiInjection($_POST['Complemento'] ?? '');
	$bairro = fncAntiInjection($_POST['Bairro'] ?? '');
	$uf = fncReplace(fncAntiInjection($_POST['UF'] ?? ''));
	$cidade = fncAntiInjection(fncConvPrimeiraPalavraMaiuscula($_POST['Cidade'] ?? ''));
	$cep = fncAntiInjection($_POST['cep'] ?? '');
	$quantoTempoNaDoutrina = fncAntiInjection($_POST['QuantoTemponaDoutrina'] ?? '');
	$atividadeProfissiona = fncAntiInjection($_POST['AtividadeProfissiona'] ?? '');
	$dispoeSemana = isset($_POST['DispoeSemana']) ? (int) $_POST['DispoeSemana'] : 0;
	$problemaForcaMaior = isset($_POST['ProblemaForcaMaior']) ? (int) $_POST['ProblemaForcaMaior'] : 0;
	$escolaridade = fncAntiInjection($_POST['Escolaridade'] ?? '');
	$nacionalidade = isset($_POST['Nacionalidade']) ? (int) $_POST['Nacionalidade'] : 0;
	$identificacao = $_POST['Identificacao'] ?? '';
	$dtInscricao = date("Y-m-d H:i:s");

	// Verifica se o e-mail está definido
	if (!$email) {
		echo json_encode([
			'status' => false, 
			'mensagem' => 'E-mail não existente'
		]);
		exit;
	}

	$conn->begin_transaction();

	try {
		// UPDATE usando prepared statement para segurança
		$stmt = $conn->prepare("
				UPDATE tbl_cadastro SET 
						telResidencial = ?, 
						telTrabalho = ?, 
						telCelular = ?, 
						email = ?, 
						confirmarEmail = ?, 
						pais = ?, 
						endereco = ?, 
						complemento = ?, 
						bairro = ?, 
						cidade = ?, 
						uf = ?, 
						cep = ?, 
						qtTempDoutrina = ?, 
						atividadeProf = ?, 
						dispoeSemana = ?, 
						problemaForcaMaior = ?, 
						escolaridade = ?, 
						nacionalidade = ?, 
						identificacao = ? 
				WHERE inscricao = ?
		");
		$stmt->bind_param(
				"sssssssssssssssiisss",
				$telResidencial,
				$telTrabalho,
				$telCelular,
				$email,
				$confirmarEmail,
				$pais,
				$endereco,
				$complemento,
				$bairro,
				$cidade,
				$uf,
				$cep,
				$quantoTempoNaDoutrina,
				$atividadeProfissiona,
				$dispoeSemana,
				$problemaForcaMaior,
				$escolaridade,
				$nacionalidade,
				$identificacao,
				$matricula
		);
		$resultado = $stmt->execute();

		//------------------------------------------------------------------------------
		//Select para recuperar o nome do curso 
		$stmt = $conn->prepare("SELECT idCurso, nomeCurso FROM tbl_curso WHERE (status = 1) AND (idCurso = ?)");
		$stmt->bind_param("i", $idCur);
		$stmt->execute();
		// Declare as variáveis que vão receber os dados
		$stmt->bind_result($idCurso, $nomeCurso);
		$stmt->fetch();

		$stmt->free_result(); // <== Limpa o resultado antes de nova execução
		$stmt->close();
		//------------------------------------------------------------------------------

		// Inserção no relacionamento curso-cadastro
		$stmt1 = $conn->prepare("
				INSERT INTO tbl_curso_cadastro (idCadastro, idCurso, dtCadastroCurso, idSituacao)
				VALUES (?, ?, ?, 1)
		");
		$stmt1->bind_param("iis", $idCad, $idCur, $dtInscricao);
		$resultado1 = $stmt1->execute();

		// Se tudo deu certo, comita a transação
		$conn->commit();

		if (!$resultado || !$resultado1) {
				$msg = "Erro ao atualizar dados!";
		} else {
			echo json_encode([
				'status' => true,  
				'mensagem' => 'Sua inscrição foi realizada com sucesso! Você receberá e-mail com dados para acessar o curso alguns dias antes do início das atividades.<br /><br />Prof. Alaciel Franklin Almeida - Coordenador do Curso.', 
				'idCadastro' => $idCad
			]);

			// <div align='center'><a href='../frm_ead.php'>Voltar</a></div>"				
			//Enviar e-mail de agradecimento
			fnc_email_inscricao($nome, $email, $inscricao, $nomeCurso);
		}
	} catch (Exception $e) {

		$conn->rollback();

		// Registrar log de erro da exceção
		if (function_exists('registrarLog')) {
			registrarLog("Erro ao atualizar status: " . $e->getMessage());
		}

		http_response_code(500);
		echo json_encode(["status" => false, "mensagem" => "Erro inscrição não atualizada."]);

		if (isset($stmt) && $stmt) $stmt->close();
		if (isset($stmtBackup) && $stmtBackup) $stmtBackup->close();
		if (isset($stmtUpdate) && $stmtUpdate) $stmtUpdate->close();
	}
?>