<?php 
session_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');

require_once('../includes/conexao.php');
require('../includes/funcoes.php');
require('../includes/configGoogle.php');

$tipo = isset($_REQUEST["Tipo"]) ? $_REQUEST["Tipo"] : "";
$captcha = $_POST['g-recaptcha-response'] ?? '';
$remoteip = $_SERVER['REMOTE_ADDR'] ?? null;
// --- Captura chaves ---
$secret = Config::GOOGLE_RECAPTCHA_SECRET_KEY;
$url = Config::GOOGLE_RECAPTCHA_VERIFY_URL;

$recaptchaResponse = verificarRecaptcha($captcha, $remoteip, $secret, $url);

if ($recaptchaResponse['success'] === false) {
	echo json_encode([
		"status" => false,
		"mensagem" => "Erro ao conectar com a API do Google."
	]);
	exit;
}

if ($recaptchaResponse['score'] < Config::GOOGLE_MIN_SCORE) {
	echo json_encode([
		"status" => false,
		"mensagem" => 'Pontuação reCAPTCHA muito baixa. Possível bot.'
	]);
	exit;
}

if ($recaptchaResponse['success']) {
  if($tipo == 'N') {
    //Anti Injection
    $nome = fncAntiInjection($_POST["Nome"]);
    $email = fncAntiInjection($_POST["Email"]);

    //Verifica o nome antes de incluir na tabela de tbl_cadastro.
    $stmt = $conn->prepare("SELECT idCadastro, inscricao FROM tbl_cadastro WHERE UPPER(email) = UPPER(?)");
    $stmt->bind_param("s", $email); // "s" para string
    $stmt->execute();
    // Declare as variáveis que vão receber os dados
    $stmt->bind_result($idCad, $numInscricao);
    $stmt->fetch();

    //Verifica se a variável &idCad não existe, se não existir cadastra.
    if ((is_null($idCad)) || ($idCad == 0)) {

      $conn->begin_transaction();

      try {
        
        //Seleciona o último id inserido da tabela cadastro para ser conctenado o número de Inscrição gerado pela Função fncGeraIncricaoRand.
        $sql = 'SELECT idCadastro FROM tbl_cadastro ORDER BY idCadastro DESC LIMIT 1';
        $resultado = mysqli_query($conn, $sql);

        $rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC);
        $cod = $rs["idCadastro"];
        
        //------------------------------------------------------------------------------

        //Variáveis
        $idCurso = $_POST["Curso"];
        $inscricao = fncGeraIncricaoRand($cod);
        $nome = fncAntiInjection($_POST["Nome"]) ;
        $nome = fncReplace($nome);
        $dataDeNacimento = fncAntiInjection($_POST["DatadeNacimento"]);
        $telResidencial = trim($_POST["TelResidencial"]);
        $telTrabalho = trim($_POST["TelTrabalho"]);
        $telCelular = trim($_POST["TelCelular"]);
        $email = fncConvTodasPalavraMinusculas($_POST["Email"]);
        //Função para criar username a partir no email
        $username = fncCriarUsername($email);
        $confirmarEmail = fncConvTodasPalavraMinusculas($_POST["ConfirmarEmail"]);
        $pais = fncConvPrimeiraPalavraMaiuscula($_POST["Pais"]);
        ////$pais = $_POST["Pais"];
        $endereco = fncAntiInjection($_POST["Endereco"]);
        $complemento = fncAntiInjection($_POST["Complemento"]);
        $bairro = fncConvPrimeiraPalavraMaiuscula(fncAntiInjection($_POST["Bairro"]));
        $uf = fncAntiInjection($_POST["UF"]);
        $uf = fncReplace($uf);
        $cidade = fncAntiInjection(fncConvPrimeiraPalavraMaiuscula($_POST["Cidade"]));
        $cep = fncAntiInjection($_POST["cep"]);
        $quantoTempoNaDoutrina = fncAntiInjection($_POST["QuantoTemponaDoutrina"]);
        $atividadeProfissiona = fncAntiInjection($_POST["AtividadeProfissiona"]);
        $dispoeSemana = $_POST["DispoeSemana"];
        $problemaForcaMaior = $_POST["ProblemaForcaMaior"];
        $escolaridade = fncAntiInjection($_POST["Escolaridade"]);
        $nacionalidade = $_POST["Nacionalidade"];
        $identificacao = $_POST["Identificacao"];
        $dateCad = date('Y/m/d, H:i:s');

        //------------------------------------------------------------------------------
        //Select para recuperar o nome do curso 
        $stmt = $conn->prepare("SELECT idCurso, nomeCurso FROM tbl_curso WHERE (status = 1) AND (idCurso = ?)");
        $stmt->bind_param("i", $idCurso);
        $stmt->execute();
        // Declare as variáveis que vão receber os dados
        $stmt->bind_result($idCurso, $nomeCurso);
        $stmt->fetch();

        $stmt->free_result(); // <== Limpa o resultado antes de nova execução
        $stmt->close();
        //------------------------------------------------------------------------------

        //Verifica se a variável $nome existe.
        if(isset($nome)){

          //Query de inserção.
          $sql = "INSERT INTO tbl_cadastro
                      (inscricao,
                      nome,
                      username,
                      dataNacimento,
                      telResidencial,
                      telTrabalho,
                      telCelular,
                      email,
                      confirmarEmail,
                      pais,
                      endereco,
                      complemento,
                      bairro,
                      cidade,
                      uf,
                      cep,
                      qtTempDoutrina,
                      atividadeProf,
                      dispoeSemana,
                      problemaForcaMaior,
                      escolaridade,
                      identificacao,
                      nacionalidade)
                  VALUES
                      ('".$inscricao."',
                      '".$nome."',
                      '".$username."',
                      '".$dataDeNacimento."',
                      '".$telResidencial."',
                      '".$telTrabalho."',
                      '".$telCelular."',
                      '".$email."',
                      '".$confirmarEmail."',
                      '".$pais."',
                      '".$endereco."',
                      '".$complemento."',
                      '".$bairro."',
                      '".$cidade."',
                      '".$uf."',
                      '".$cep."',
                      '".$quantoTempoNaDoutrina."',
                      '".$atividadeProfissiona."',
                      ".$dispoeSemana.",
                      ".$problemaForcaMaior.",
                      '".$escolaridade."',
                      '".$identificacao."',
                      ".$nacionalidade.")";

          $resultado = mysqli_query($conn, $sql);	

          //Último id inserido.
          $idRetornoDoCadastro = mysqli_insert_id($conn); 

          //Insere o id da tabela cadastro e curso para o relacionamento.
          $sql1 = "INSERT INTO tbl_curso_cadastro (idCadastro, idCurso, dtCadastroCurso, idSituacao)
                  VALUES ($idRetornoDoCadastro, $idCurso, '$dateCad', 1)";

          //Envia a query para o banco de dados.			
          $resultado1 = mysqli_query($conn, $sql1);

          //Verifica a matricula	
          if (!$resultado) {	
              //echo "Erro ao executar INSERT INTO tbl_curso_cadastro: " . $stmt->error;
              echo json_encode(['status' => false, 'mensagem' => 'Erro ao inserir dados!']);
          } else {

              // Se tudo deu certo, comita a transação
              $conn->commit();

              echo json_encode([
                'status' => true, 
                'mensagem' => 'Sua inscrição foi realizada com sucesso! Você receberá uma mensagem via e-mail com os dados para acesso ao curso. Saudações fraternas.\nProf. Alaciel Franklin Almeida - Coordenador do Curso'
              ]);

              //Enviar e-mail de agradecimento
              fnc_email_inscricao($nome, $email, $inscricao, $nomeCurso);
          }
        }
      } catch (Exception $e) {

        $conn->rollback();

        // Registrar log de erro da exceção
        if (function_exists('registrarLog')) {
          registrarLog("Erro ao atualizar status: " . $e->getMessage());
        }

        http_response_code(500);
        echo json_encode(["status" => false, "mensagem" => "Erro inscrição não atualizada."]);

        if (isset($stmt) && $stmt) $stmt->close();
      }

    } else {
      echo json_encode([
        'status' => false, 
        'mensagem' => 'Você já possui uma inscrição! O seu número é ' . $numInscricao . '.'
      ]);
    }

  } else {
    //Recuperar Inscrição
    $nome = fncAntiInjection($_POST["NomeExistente"]) ;
    $nome = fncReplace($nome);
    $email = fncConvTodasPalavraMinusculas($_POST["EmailExistente"]);

    $sql = "SELECT idCadastro, inscricao, nome, email
            FROM tbl_cadastro
            WHERE (nome = '".$nome."') or (email = '".$email."');";

    $resultado = mysqli_query($conn, $sql);	
    $rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC);

    $idCadastro_ = $rs["idCadastro"];
    $matricula_ = $rs["inscricao"];
    $nome_ = $rs["nome"];
    $email_ = $rs["email"];

    //Verifica a existéncia da valor nas variáveis.
    if (isset($matricula_) and isset($email_)) {
      $_SESSION['__inscricao'] = $matricula_;
      
      fncEmailRecuperarMatricula($email_, $matricula_);	
      
      echo json_encode(['status' => true, 'idCadastro' => $idCadastro_]);
    } else {
      echo json_encode(['status' => false, 'mensagem' => 'Nome ou e-mail inexistente(s)']);
    }	
  }
} else {
    $errorCodes = $response['error-codes'] ?? ['unknown-error'];
    echo json_encode([
        "status" => false,
        "mensagem" => "Falha na verificação reCAPTCHA.",
        "erros" => $errorCodes
    ]);
}

//Fecha a conexão com o banco
mysqli_close($conn);	
?>