<?php
session_start();

if (!isset($_SESSION['__idUsu'])) {
  header("Location: ../frm_login.php");
  exit;
}

header('Content-Type: application/json');

require("../includes/conexao.php");
require("../includes/funcoes.php");

$nome = isset($_POST["nome"]) ? trim($_POST["nome"]) : null;
$curso = isset($_POST["curso"]) ? trim($_POST["curso"]) : null;
$situacao = isset($_POST["situacao"]) ? trim($_POST["situacao"]) : null;

// Aplica limpeza
$nome = limpar($nome);
$curso = limpar($curso);
$situacao = limpar($situacao);

$dados = [];

// Busca cadastros
$sql = "SELECT CAD.idCadastro, CAD.inscricao, CAD.nome, CAD.email, CAD.cidade, CAD.uf,
            CUR_CAD.idRelCursoCadastro, CUR_CAD.dtCadastroCurso,
            CUR.nomeCurso, SIT.nomeSituacao
        FROM tbl_cadastro CAD
        INNER JOIN tbl_curso_cadastro CUR_CAD ON CAD.idCadastro = CUR_CAD.idCadastro
        INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
        INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
        WHERE 1=1";

// Filtros condicionais
if (!empty($nome)) {
  $sql .= " AND CAD.nome LIKE '%$nome%'";
}
if (!empty($curso)) {
  $sql .= " AND CUR.nomeCurso = '$curso'";
}
if (!empty($situacao)) {
  $sql .= " AND SIT.nomeSituacao = '$situacao'";
}

$sql .= " ORDER BY CAD.nome, CUR.nomeCurso ASC";

$result = mysqli_query($conn, $sql);

$agrupado = [];

while ($linha = mysqli_fetch_object($result)) {
  $id = $linha->idCadastro;

  if (!isset($agrupado[$id])) {
    // Cria a estrutura básica para o aluno
    $agrupado[$id] = [
      "idCadastro" => $linha->idCadastro,
      "inscricao" => $linha->inscricao,
      "nome" => htmlspecialchars($linha->nome, ENT_QUOTES, 'UTF-8'),
      "cursos" => [],
      "datas" => [],
      "situacoes" => [],
      "idRelCursoCadastro" => []
    ];
  }

  // Adiciona cursos, datas e situações sem duplicar inscrição
  $agrupado[$id]["cursos"][] = htmlspecialchars($linha->nomeCurso, ENT_QUOTES, 'UTF-8');
  $agrupado[$id]["datas"][] = htmlspecialchars(formataData($linha->dtCadastroCurso), ENT_QUOTES, 'UTF-8');
  $agrupado[$id]["situacoes"][] = htmlspecialchars($linha->nomeSituacao, ENT_QUOTES, 'UTF-8');
  $agrupado[$id]["idRelCursoCadastro"][] = "<input type='checkbox' class='row-checkbox' name='selecionados[]' value='{$linha->idRelCursoCadastro}' data-id='{$linha->idRelCursoCadastro}'>";
}

// Monta array final
foreach ($agrupado as $item) {
  $dados[] = [
    "idCadastro" => $item["idCadastro"],
    "inscricao" => $item["inscricao"],
    "nome" => $item["nome"],
    "cursos" => implode("<br>", $item["cursos"]),
    "datas" => implode("<br>", $item["datas"]),
    "situacoes" => implode("<br>", $item["situacoes"]),
    "idRelCursoCadastro" => implode("<br>", $item["idRelCursoCadastro"]),
  ];
}

echo json_encode(["data" => $dados]);

mysqli_close($conn);
?>