<?php
	session_start();

	if (!isset($_SESSION['__idUsu'])) {
    header("Location: ../frm_login.php");
    exit;
	}

	header('Content-Type: application/json  charset=utf-8');

	require('../includes/conexao.php');
	require('../includes/funcoes.php');

	$nome = isset($_POST["nome"]) ? trim($_POST["nome"]) : null;
	$curso = isset($_POST["curso"]) ? trim($_POST["curso"]) : null;
	$situacao = isset($_POST["situacao"]) ? trim($_POST["situacao"]) : null;

	$dados = [];

	// Aplica limpeza
	$nome = limpar($nome);
	$curso = limpar($curso);
	$situacao = limpar($situacao);

	$sql = "SELECT DISTINCT CAD.idCadastro, CAD.inscricao, CAD.nome, CAD.email, CAD.cidade, CAD.uf
					FROM tbl_cadastro CAD
					INNER JOIN tbl_curso_cadastro CUR_CAD ON CAD.idCadastro = CUR_CAD.idCadastro
					INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
					INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
					WHERE 1=1";

	// Filtros condicionais
	if (!empty($nome)) {
			$sql .= " AND CAD.nome LIKE '%$nome%'";
	}
	if (!empty($curso)) {
			$sql .= " AND CUR.nomeCurso = '$curso'";
	}
	if (!empty($situacao)) {
			$sql .= " AND SIT.nomeSituacao = '$situacao'";
	}

	$sql .= " ORDER BY CAD.nome";

	$result = mysqli_query($conn, $sql);

	while ($linha = mysqli_fetch_object($result)) {
		$id = $linha->idCadastro;

		$sqlCursos = "SELECT CUR.nomeCurso, CUR_CAD.dtCadastroCurso, SIT.nomeSituacao
									FROM tbl_curso_cadastro CUR_CAD
									INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
									INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
									WHERE CUR_CAD.idCadastro = $id";

		// Filtros condicionais
		if (!empty($curso)) {
			$sqlCursos .= " AND CUR.nomeCurso = '$curso'";
		}
		if (!empty($situacao)) {
			$sqlCursos .= " AND SIT.nomeSituacao = '$situacao'";
		}

		$sqlCursos .= " ORDER BY CUR.nomeCurso ASC";

		$res = mysqli_query($conn, $sqlCursos);

		$cursos = [];
		$datas = [];
		$situacoes = [];

		$cursosTemp = [];
		$datasTemp = [];
		$situacoesTemp = [];

		// Captura os dados brutos
		while ($r = mysqli_fetch_object($res)) {
				$cursosTemp[] = htmlspecialchars($r->nomeCurso, ENT_QUOTES, 'UTF-8');
				$datasTemp[] = htmlspecialchars(formataData($r->dtCadastroCurso), ENT_QUOTES, 'UTF-8');
				$situacoesTemp[] = htmlspecialchars($r->nomeSituacao, ENT_QUOTES, 'UTF-8');
		}

		// Aplica <strong> em índices alternados se houver mais de 1 item
		foreach ($cursosTemp as $index => $item) {
				$cursos[] = (count($cursosTemp) > 1 && $index % 2 === 0) ? "<strong>$item</strong>" : $item;
		}
		foreach ($datasTemp as $index => $item) {
				$datas[] = (count($datasTemp) > 1 && $index % 2 === 0) ? "<strong>$item</strong>" : $item;
		}
		foreach ($situacoesTemp as $index => $item) {
				$situacoes[] = (count($situacoesTemp) > 1 && $index % 2 === 0) ? "<strong>$item</strong>" : $item;
		}

		$dados[] = [
			"idCadastro" => $linha->idCadastro,
			"inscricao" => $linha->inscricao,
			"nome" => htmlspecialchars($linha->nome, ENT_QUOTES, 'UTF-8'),
			"email" => htmlspecialchars($linha->email, ENT_QUOTES, 'UTF-8'),
			"cidade" => htmlspecialchars($linha->cidade, ENT_QUOTES, 'UTF-8'),
			"uf" => htmlspecialchars($linha->uf, ENT_QUOTES, 'UTF-8'),
			"cursos" => implode("<br>", $cursos),
			"datas" => implode("<br>", $datas),
			"situacoes" => implode("<br>", $situacoes),
		];
	}

	echo json_encode(["data" => $dados]);

	mysqli_close($conn);
?>