<?php
session_start();

header('Content-Type: text/html; charset=utf-8', true);

if (!isset($_SESSION['__idUsu'])) {
  header("Location: frm_login.php");
  exit;
}

require('includes/conexao.php');
require('includes/funcoes.php');
require('includes/cabecalho.php');
require('includes/menu.php');
?>

<div class="container my-5">
  <div class="card">
    <div class="card-body">
      <h3 class="card-title mb-4">Listagem de inscritos</h3>
        <div class="table-responsive-xxl">
          <!-- Filtros personalizados -->
          <div class="row mb-3">
            <div class="col-sm-5">
              <input type="text" id="filtroNome" class="form-control mb-0" placeholder="Filtrar por Nome">
            </div>
            <div class="col-sm-6">
              <select id="filtroCurso" class="form-select mb-0">
                <option value="">Todos os Cursos</option>
                <?php
                  $sqlCursos = "SELECT DISTINCT nomeCurso FROM tbl_curso ORDER BY nomeCurso";
                  $resCursos = mysqli_query($conn, $sqlCursos);
                  while ($row = mysqli_fetch_assoc($resCursos)) {
                    echo "<option value=\"{$row['nomeCurso']}\">{$row['nomeCurso']}</option>";
                  }
                ?>
              </select>
            </div>
          </div>
          <form id="frmAtualizaStatus" name="frmNovaInscricao" method="POST" onsubmit="return fncAtualizaStatus(event);">
            <div class="row mb-3">
              <div class="col-sm-3">
                <select id="filtroSituacao" class="form-select mb-0">
                  <option value="">Todas as Situações</option>
                  <?php
                    $sqlSit = "SELECT nomeSituacao FROM tbl_situacao_aluno ORDER BY nomeSituacao";
                    $resSit = mysqli_query($conn, $sqlSit);
                    while ($row = mysqli_fetch_assoc($resSit)) {
                      echo "<option value=\"{$row['nomeSituacao']}\">{$row['nomeSituacao']}</option>";
                    }
                  ?>
                </select>
              </div>
              <div class="col-sm-3">
                <select id="novoSituacao" class="form-select mb-0">
                  <option value="">Selecione novo situação</option>
                  <?php
                    $sqlNovoSit = "SELECT nomeSituacao FROM tbl_situacao_aluno ORDER BY nomeSituacao";
                    $resNovoSit = mysqli_query($conn, $sqlNovoSit);
                    while ($row = mysqli_fetch_assoc($resNovoSit)) {
                      echo "<option value=\"{$row['nomeSituacao']}\">{$row['nomeSituacao']}</option>";
                    }
                  ?>
                </select>
              </div>
              <div class="col-sm-3">
                <button type="submit" class="btn btn-primary w-100">Atualizar Status</button>
              </div>
            </div> 
          </form>
          <table id="tblAlteracaoStatus" class="table table-bordered table-hover align-middle text-center responsive">
            <thead class="table-light">
              <tr>
                <th class="text-center">Nº</th>
                <th class="text-center">Inscrição</th>
                <th class="text-right">Nome</th>
                <th class="text-right">Curso</th>
                <th class="text-center">Data</th>
                <th class="text-center">Situação</th>
                <th><input type="checkbox" id="select-all"></th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
    </div>
  </div>
</div>

<?php
	mysqli_close($conn);
	require("includes/rodape.php");
?>
