<?php
	session_start();

  //Verifica se existe a session.
	if (!isset($_SESSION['__idUsu'])) {
    header("Location: ../frm_login.php");
    exit;
	}

  header("Content-Type: text/html; charset=utf-8", true);

	require('includes/conexao.php');
	require('includes/funcoes.php');
	require('includes/cabecalho.php');
	require('includes/menu.php');

  //Variaveis locais
  $a = (isset($_GET["acao"]) ? $_GET["acao"] : "");
  $r = (integer) (isset($_GET['r']) ? $_GET['r'] : 0);  
  $idCur = (integer) (isset($_GET["idCurso"]) ? $_GET["idCurso"] : 0);
  $msgUsu = (isset($_GET["msg"]) ? $_GET["msg"] : "");

  //Query
  $sql = "SELECT
          CUR.idCurso,
          CUR.nomeCurso,
          CUR.siglaCurso,
          CUR.descricaoCurso,
          CUR.dtCadastroCurso,
          CUR.status
        FROM tbl_curso CUR 
        WHERE (CUR.idCurso = $idCur);";

  //Executa a query e retorna;
  $resultado = mysqli_query($conn, $sql);

  //Busca o resultado de uma linha e o coloca como uma matriz associativa.
  $rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC);

  //------------------------------------------------------------------------------

  $idCurso = $rs["idCurso"];
  $nomeCurso = $rs["nomeCurso"];
  $siglaCurso = $rs["siglaCurso"];
  $descricaoCurso = $rs["descricaoCurso"];
  $dtCadastroCurso = $rs["dtCadastroCurso"];
  $statusCurso = $rs["status"];	

  if($a != 'e'){
    $tpAcao = 'Incluir curso';
  }else{
    $tpAcao = 'Editar curso';
  }
?>

  <div class="container my-5">
    <div class="card shadow-sm">
      <div class="card-body">
        <h3 class="card-title mb-4"><?php echo $tpAcao; ?></h3>
        <form id="frmCurso" name="frmCurso" method="POST" onsubmit="return fncValidarFormCurso(event);">
          <?php //include("includes/validacao.php"); ?>	
          <input type="hidden" id="idCurso" name="idCurso" value="<?php echo $idCurso; ?>" />
          <!-- <input type="hidden" id="acao" name="acao" value="<?// phpecho $a; ?>" /> -->
          <!-- Nome do Curso -->
          <div class="mb-3">
            <label for="NomeCurso" class="form-label">Nome:</label>
            <input type="text" class="form-control" id="NomeCurso" name="NomeCurso" maxlength="150" value="<?php echo $nomeCurso; ?>">
            <div class="invalid-feedback">Preencha o nome do curso.</div>
          </div>
          <!-- Sigla do Curso -->
          <div class="mb-3">
            <label for="SiglaCurso" class="form-label">Sigla:</label>
              <input type="text" class="form-control" id="SiglaCurso" name="SiglaCurso" maxlength="30" value="<?php echo $siglaCurso; ?>">
          </div>
          <!-- Descrição -->
          <div class="mb-3">
            <label for="Descricao" class="form-label">Descrição:</label>
            <textarea class="form-control" id="Descricao" name="Descricao" rows="5"><?php echo $descricaoCurso; ?></textarea>
            <div class="invalid-feedback">Preencha a descrição do curso.</div>
          </div>
          <!-- Status -->
          <div class="mb-3 row">
            <label class="form-label">Status:</label>
            <div class="col-sm-9 pt-2">
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="Status" id="Status_1" value="1" <?php if($statusCurso == 1){ echo "checked"; } ?>>
                <label class="form-check-label" for="Status_1">Ativo</label>
              </div>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="Status" id="Status_0" value="0" <?php if($statusCurso == 0){ echo "checked"; } ?>>
                <label class="form-check-label" for="Status_0">Desativado</label>
              </div>
            </div>
            <div id="erroDispoeSemana" class="invalid-feedback d-none">Informe sua disponibilidade na semana.</div>
          </div>
          <!-- Botão de Enviar -->
          <div class="text-center">
            <button type="submit" class="btn btn-primary" id="curso">Enviar</button>
          </div>
        </form>
      </div>
    </div>
  </div>

<?php
  // Libera e fecha
  mysqli_free_result($resultado);
  mysqli_close($conn);

	require("includes/rodape.php");
?>