<?php
session_start();
require('includes/conexao.php');
require('includes/funcoes.php');

// Cabeçalhos para forçar download do Excel
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=RelatorioDeCadastro.xls");
header("Pragma: no-cache");
header("Cache-Control: no-cache, must-revalidate");

// Recebe o curso como parâmetro (se houver)
$curso = filter_input(INPUT_GET, 'curso', FILTER_VALIDATE_INT);

// Query principal
$sql = "SELECT
            CAD.idCadastro,
            CAD.inscricao, 
            CAD.nome, 
            CAD.email,
            CAD.escolaridade,
            CAD.dataNacimento,
            CUR.nomeCurso,
            CUR_CAD.dtCadastroCurso, 
            SIT.nomeSituacao
        FROM tbl_cadastro CAD
        INNER JOIN tbl_curso_cadastro CUR_CAD ON CAD.idCadastro = CUR_CAD.idCadastro			
        INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
        INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
        " . ($curso ? "WHERE CUR.idCurso = " . intval($curso) : "") . "
        ORDER BY CAD.inscricao ASC";

$resultado = mysqli_query($conn, $sql);

if (!$resultado) {
    die("Erro na consulta: " . mysqli_error($conn));
}

// Inicia a tabela
$linhas = [];
$linhas[] = "<table border='0'>
<tr style='font-size:13px; font-family:Verdana; font-weight:bold; background-color:#E9F7E1;'>
    <th>Inscrição</th>
    <th width='300'>Nome</th>
    <th width='140'>Data de Nascimento</th>
    <th>E-mail</th>
    <th>Escolaridade</th>
    <th width='350'>Curso</th>
    <th>Situação</th>
    <th>Data Inscrição</th>
</tr>";

$cont = 0;

// Monta as linhas da tabela
while ($rs = mysqli_fetch_assoc($resultado)) {
    $bgColor = ($cont % 2 === 0) ? "#EEF0F1" : "#FFFFFF"; // cor zebra
    $linhas[] = "<tr style='font-size:12px; font-family:Verdana; background-color:$bgColor'>";
    $linhas[] = "<td align='center'>" . htmlspecialchars($rs['inscricao']) . "</td>";
    $linhas[] = "<td align='left'>" . htmlspecialchars(fncReplace($rs['nome'])) . "</td>";
    $linhas[] = "<td align='center'>" . formataData($rs['dataNacimento']) . "</td>";
    $linhas[] = "<td align='left'>" . htmlspecialchars(strtolower($rs['email'])) . "</td>";
    $linhas[] = "<td align='left'>" . htmlspecialchars($rs['escolaridade']) . "</td>";
    $linhas[] = "<td align='left'>" . htmlspecialchars($rs['nomeCurso']) . "</td>";
    $linhas[] = "<td align='left'>" . htmlspecialchars($rs['nomeSituacao']) . "</td>";
    $linhas[] = "<td align='center'>" . formataData($rs['dtCadastroCurso']) . "</td>";
    $linhas[] = "</tr>";
    $cont++;
}

$linhas[] = "</table>";

// Exibe tabela
echo implode("\n", $linhas);

// Libera recursos
mysqli_free_result($resultado);
mysqli_close($conn);



// session_start();
// require('includes/conexao.php');
// require('includes/funcoes.php');

// // Cabeçalhos para forçar download do Excel
// header("Content-Type: application/vnd.ms-excel; charset=iso-8859-1");
// header("Content-Disposition: attachment; filename=RelatorioDeCadastro.xls");
// header("Pragma: no-cache");
// header("Cache-Control: no-cache, must-revalidate");

// // Adiciona BOM para evitar problemas de acentuação no Excel
// //echo "\xEF\xBB\xBF";

// // Recebe o curso como parâmetro (se houver)
// $curso = filter_input(INPUT_GET, 'curso', FILTER_VALIDATE_INT);

// // Query principal
// $sql = "SELECT
//         CAD.idCadastro,
//         CAD.inscricao, 
//         CAD.nome, 
//         CAD.email,
//         CAD.escolaridade,
//         CAD.dtNascimento,
//         CUR.nomeCurso,
//         CUR_CAD.dtCadastroCurso, 
//         SIT.nomeSituacao
//     FROM tbl_cadastro CAD
//     INNER JOIN tbl_curso_cadastro CUR_CAD ON CAD.idCadastro = CUR_CAD.idCadastro			
//     INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
//     INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
//     " . ($curso ? "WHERE CUR.idCurso = $curso" : "") . "
//     ORDER BY CAD.inscricao ASC";

// $resultado = mysqli_query($conn, $sql);

// // Começa buffer
// $linhas = [];

// $linhas[] = "<table border='0'>
//               <tr style='font-size:13px; font-family:Verdana; font-weight:bold; background-color:#E9F7E1;'>
//                 <th>Inscrição</th>
//                 <th width='300'>Nome</th>
//                 <th width='140'>Data de Nascimento</th>
//                 <th>E-mail</th>
//                 <th>Escolaridade</th>
//                 <th width='350'>Curso</th>
//                 <th>Situação</th>
//                 <th>Data Inscrição</th>
//               </tr>";

// $cont = 0;

// while ($rs = mysqli_fetch_assoc($resultado)) {
//     $linhaStyle = ($cont % 2 == 0) ? "background-color:#EEF0F1;" : "";

//     $linhas[] = "<tr style='font-size:12px; font-family:Verdana; $linhaStyle'>";
//     $linhas[] = "<td align='center'>" . htmlspecialchars($rs['inscricao']) . "</td>";
//     $linhas[] = "<td align='left'>" . htmlspecialchars(fncReplace($rs['nome'])) . "</td>";
//     $linhas[] = "<td align='center'>" . formataData($rs['dtNascimento']) . "</td>";
//     $linhas[] = "<td align='left'>" . htmlspecialchars(strtolower($rs['email'])) . "</td>";
//     $linhas[] = "<td align='left'>" . htmlspecialchars($rs['escolaridade']) . "</td>";
//     $linhas[] = "<td align='left'>" . htmlspecialchars($rs['nomeCurso']) . "</td>";
//     $linhas[] = "<td align='left'>" . htmlspecialchars($rs['nomeSituacao']) . "</td>";
//     $linhas[] = "<td align='center'>" . formataData($rs['dtCadastroCurso']) . "</td>";
//     $linhas[] = "</tr>";

//     $cont++;
// }

// $linhas[] = "</table>";

// // Exibe
// echo implode("\n", $linhas);

// // Libera recursos
// mysqli_free_result($resultado);
// mysqli_close($conn);
?>