<?php
  session_start();

  //Verifica se existe a session.
  if (!isset($_SESSION['__idUsu'])) {
    header("Location: ../frm_login.php");
    exit;
  }

  header("Content-Type: text/html; charset=utf-8", true);

  require_once('includes/conexao.php');
  require('includes/funcoes.php');
  require('includes/cabecalho.php');
  require('includes/menu.php');

  //Variaveis locais
  $sum = 0;

  //Query para gráfico de barras e tabela de cursos
  $sql = "SELECT
          SIT.idSituacao,
          SIT.nomeSituacao,
          CUR.status,
          CUR.nomeCurso,
          COUNT(SIT.nomeSituacao) AS total_situacao
          FROM tbl_cadastro CAD
          INNER JOIN tbl_curso_cadastro CUR_CAD ON CAD.idCadastro = CUR_CAD.idCadastro
          INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
          INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
          WHERE SIT.idSituacao IN (1, 2, 3, 4)
          GROUP BY SIT.idSituacao, CUR.status, CUR.nomeCurso 
          ORDER BY SIT.idSituacao, CUR.nomeCurso ASC;";

  //Executa a query e retorna;
  $resultado = mysqli_query($conn, $sql);

  //Query para gráfico de pizza
  $sql1 = "SELECT 
          SIT.nomeSituacao,
          COUNT(SIT.nomeSituacao) AS situacao
          FROM tbl_cadastro CAD
          INNER JOIN tbl_curso_cadastro CUR_CAD on (CAD.idCadastro = CUR_CAD.idCadastro)
          INNER JOIN tbl_curso CUR ON (CUR.idCurso = CUR_CAD.idCurso)
          INNER JOIN tbl_situacao_aluno SIT on (SIT.idSituacao = CUR_CAD.idSituacao)
          WHERE SIT.idSituacao IN (1, 2, 3, 4)
          GROUP BY SIT.nomeSituacao, SIT.idSituacao
          ORDER BY SIT.idSituacao ASC;";

  //Executa a query e retorna;
  $resultado1 = mysqli_query($conn, $sql1);

  $sql = "SELECT
          SIT.idSituacao,
          SIT.nomeSituacao,
          CUR.status,
          CUR.nomeCurso,
          COUNT(SIT.nomeSituacao) AS total_situacao
          FROM tbl_cadastro CAD
          INNER JOIN tbl_curso_cadastro CUR_CAD ON CAD.idCadastro = CUR_CAD.idCadastro
          INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
          INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
          WHERE SIT.idSituacao IN (1, 2, 3, 4)
          GROUP BY CUR.nomeCurso, CUR.status, SIT.idSituacao
          ORDER BY CUR.nomeCurso, SIT.idSituacao ASC;";
  //Executa a query e retorna;
  $result = $conn->query($sql);

  $data = [];
  while ($row = $result->fetch_assoc()) {
    $data[] = $row;
  }
?>

<div class="container my-4">
  <h3 class="text-center mb-4">Relatório Quantitativo</h3>
  <form id="frmRelatorioQuantitativo" name="frmRelatorioQuantitativo" method="POST">
    <!-- Gráficos -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header text-center fw-bold">Gráfico por Situação</div>
                <div class="card-body">
                  <div id="piechart_situacao" style="width: 100%; height: 400px;"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mb-4">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header text-center fw-bold">Gráfico de Barras - Total por Ano</div>
          <div class="card-body">
            <div id="chart_div" style="width: 100%; height: 400px;"></div>
          </div>
        </div>
      </div>
    </div>
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
              <div class="card-header text-center fw-bold">Gráfico de Barras Empilhadas</div>         
              <div class="card-body">
                <div id="barchart_material" style="width: 100%; height: 500px;"></div>
              </div>
            </div>
        </div>
    </div>

    <!-- Primeira Tabela -->
    <div class="card mb-4">
      <div class="card-header text-center fw-bold">
        RELATÓRIO QUANTITATIVO DE INSCRITOS NO BANCO DE DADOS
      </div>
      <div class="card-body">
          <p class="text-center fw-semibold">Por Situação</p>
          <p class="text-center">Data: <?php echo date("d/m/Y") ?></p>
          <div class="table-responsive">
              <table class="table table-bordered table-hover align-middle">
                  <thead class="table-dark">
                      <tr>
                          <th class="text-center">Situação</th>
                          <th class="text-center">Curso</th>
                          <th class="text-center">Inscritos</th>
                          <th class="text-center">Ativo</th>
                      </tr>
                  </thead>
                  <tbody>
                      <?php
                        $cont = 0;
                        $cor = "";
                        $sum = 0;

                        // Rewind the result set to be used in the table
                        mysqli_data_seek($resultado, 0);
                        while ($rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {
                          $cor = in_array($rs["idSituacao"], [1, 3]) ? 'table-secondary' : '';
                      ?>
                      <tr class="<?php echo $cor; ?>">
                          <td class="text-center"><?php echo $rs["nomeSituacao"]; ?></td>
                          <td class="text-left"><?php echo $rs["nomeCurso"]; ?></td>
                          <td class="text-center"><?php echo $rs["total_situacao"]; ?></td>
                          <td class="text-center">
                            <?php if ($rs["status"] == 1) { ?>
                              <div class="text-center"><i class="bi bi-check-circle-fill text-success"></i></div>
                            <?php } else { ?>
                              <div class="text-center"><i class="bi bi-x-circle-fill text-danger"></i></div>
                            <?php } ?>
                          </td>
                      </tr>
                      <?php $cont++; } ?>
                  </tbody>
              </table>
          </div>
      </div>
    </div>
    <!-- Segunda Tabela -->
    <div class="card">
      <div class="card-header text-center fw-bold">
          RELATÓRIO QUANTITATIVO DE INSCRITOS POR SITUAÇÃO
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered table-hover text-center">
            <thead class="table-dark">
                <tr>
                  <th class="text-left">Situação</th>
                  <th class="text-right">Inscritos</th>
                </tr>
            </thead>
            <tbody>
              <?php
                $cont1 = 1;
                $cor1 = "";
                $totalInscritos = 0;
                // Rewind the result set to be used in the table
                mysqli_data_seek($resultado1, 0);
                while ($rs = mysqli_fetch_array($resultado1, MYSQLI_ASSOC)) {
                  $cor1 = ($cont1 % 2 == 0) ? 'table-secondary' : '';
                  $totalInscritos += $rs["situacao"];
              ?>
              <tr class="<?php echo $cor1; ?>">
                <td><?php echo $rs["nomeSituacao"]; ?></td>
                <td class="fw-bold"><?php echo $rs["situacao"]; ?></td>
              </tr>
              <?php $cont1++; } ?>
              <tr class="fw-bold">
                <td>Total geral de inscritos</td>
                <td><?php echo $totalInscritos; ?></td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </form>
</div>

<!-- Biblioteca Google Charts -->
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
    // Carrega apenas uma vez a biblioteca necessária para todos os gráficos clássicos
    google.charts.load('current', { packages: ['corechart'] });
    google.charts.setOnLoadCallback(drawCharts);

    function drawCharts() {
        drawPieChart();
        drawBarChart();
        drawStackedBarChart();
    }

    // === GRÁFICO DE PIZZA ===
    function drawPieChart() {
        const dataArray = [
            ['Situação', 'Total de Inscritos']
            <?php 
              mysqli_data_seek($resultado1, 0);
              while ($rs = mysqli_fetch_array($resultado1, MYSQLI_ASSOC)) {
                  echo ",['" . addslashes($rs['nomeSituacao']) . "', " . $rs['situacao'] . "]";
              }
            ?>
        ];

        const data = google.visualization.arrayToDataTable(dataArray);
        const options = {
            title: 'Inscritos por Situação',
            is3D: true,
            colors: ['#3366cc', '#dc3912', '#ff9900', '#109618']
        };

        new google.visualization.PieChart(document.getElementById('piechart_situacao'))
            .draw(data, options);
    }

    // === GRÁFICO DE BARRA SIMPLES (TOTAL POR ANO) ===
    function drawBarChart() {
        fetch('acoes/grafico/graficoBarroTotalPorAno.php')
          .then(response => response.json())
          .then(jsonData => {
              const chartData = [['Ano', 'Total']];
              jsonData.data.forEach(item => {
                chartData.push([item.ano.toString(), parseInt(item.total)]);
              });

              const data = google.visualization.arrayToDataTable(chartData);
              const options = {
                title: 'Total de Registros por Ano',
                hAxis: { title: 'Ano' },
                vAxis: { title: 'Total' },
                legend: 'none',
                height: 400,
                colors: ['#4285F4']
              };

              new google.visualization.ColumnChart(document.getElementById('chart_div'))
                .draw(data, options);
          });
    }

    // === GRÁFICO DE BARRA EMPILHADA POR CURSO/SITUAÇÃO ===
    function drawStackedBarChart() {
      fetch('acoes/grafico/graficoBarraSituacaoDosAlunosPorCurso.php')
        .then(response => response.json())
        .then(jsonData => {
          let cursos = {};
          const situacoes = ['Matriculado', 'Cursando', 'Concluído', 'Abandono'];

          jsonData.data.forEach(item => {
            if (!cursos[item.nomeCurso]) {
              cursos[item.nomeCurso] = { Matriculado: 0, Cursando: 0, Concluído: 0, Abandono: 0 };
            }
            cursos[item.nomeCurso][item.nomeSituacao] = parseInt(item.total_situacao);
          });

          const chartData = [['Curso', ...situacoes]];
          for (let curso in cursos) {
            chartData.push([
              curso,
              cursos[curso].Matriculado,
              cursos[curso].Cursando,
              cursos[curso].Concluído,
              cursos[curso].Abandono
            ]);
          }

          const data = google.visualization.arrayToDataTable(chartData);
          const options = {
            title: 'Situação dos Alunos por Curso',
            isStacked: true,
            height: 500,
            hAxis: { title: 'Total de Alunos' },
            vAxis: { title: 'Curso' },
            colors: ['#3366cc', '#ff9900', '#109618', '#dc3912'] // agora funciona
          };

          new google.visualization.BarChart(document.getElementById('barchart_material'))
            .draw(data, options);
        });
    }
</script>

<?php
  // Libera e fecha
  mysqli_free_result($resultado);
  mysqli_close($conn);

  require("includes/rodape.php");
?>