﻿<?php 
	session_start();
	
	if (!isset($_SESSION['__idUsu'])) {
    header("Location: ../frm_login.php");
    exit;
	}

	header("Content-Type: text/html; charset=utf-8", true);

	require_once("includes/conexao.php");
	require_once("includes/funcoes.php");
	require_once("includes/cabecalho.php");
	require("includes/configGoogle.php");

	//String de pesquisa.
	$idStr = (isset($_GET["str"]) ? $_GET["str"] : "");	

	//Tipo de pesquisa.
	$tpPeq = (isset($_GET["tpPeq"]) ? $_GET["tpPeq"] : "");

	//Id do cadastro do aluno.
	$id = (isset($_GET["id"]) ? $_GET["id"] : $idStr); 

	//Tipo de ação da página.
	$tipoAcao = $_GET["acao"]; 
	
	if ($tpPeq == 1) {
		$WHERE = "WHERE (C.inscricao = $id)";
	} else {
		$WHERE = "WHERE (C.idCadastro = $id)";
	}

	//Select para retorna todos as dados do alunos atrav�s do par�metro $id
	$sql = "SELECT 
			C.idCadastro,
			C.inscricao,
			C.nome,
			C.dataNacimento,
			C.telResidencial,
			C.telTrabalho,
			C.telCelular,
			C.email,
			C.confirmarEmail,
			C.pais,
			C.endereco,
			C.complemento,
			C.bairro,
			C.cidade,
			C.uf,
			C.cep,
			C.qtTempDoutrina,
			C.atividadeProf,
			C.dispoeSemana,
			C.problemaForcaMaior,
			C.escolaridade,
			C.identificacao,
			C.nacionalidade
		FROM tbl_cadastro C
		INNER JOIN tbl_curso_cadastro CC on (C.idCadastro = CC.idCadastro)
		INNER JOIN tbl_curso CUR on (CUR.idCurso = CC.idCurso)
		$WHERE
		GROUP BY C.inscricao, C.nome";

	//Executa a query e retorna;
	$resultado = mysqli_query($conn, $sql);

	//Busca o resultadmysqli_querynha e o coloca como uma matriz associativa.
	$rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC);

	//------------------------------------------------------------------------------

	//Variáveis
	$idCadastro = $rs["idCadastro"];
	$inscricao = $rs["inscricao"];
	$nome = $rs["nome"];
	$dataDeNacimento = $rs["dataNacimento"];
	$telResidencial = $rs["telResidencial"];
	$telTrabalho = $rs["telTrabalho"];
	$telCelular = $rs["telCelular"];
	$email = $rs["email"];
	$confirmarEmail = $rs["confirmarEmail"];
	$pais = $rs["pais"];
	$endereco = $rs["endereco"];
	$complemento = $rs["complemento"];
	$bairro = $rs["bairro"];
	$uf = $rs["uf"];
	$cidade = $rs["cidade"];
	$cep = $rs["cep"];
	$quantoTempoNaDoutrina = $rs["qtTempDoutrina"];
	$atividadeProfissional = $rs["atividadeProf"];
	$dispoeSemana = $rs["dispoeSemana"];
	$problemaForcaMaior = $rs["problemaForcaMaior"];
	$escolaridade = $rs["escolaridade"];
	$identificacao = $rs["identificacao"];
	$nacionalidade = $rs["nacionalidade"];
?>

<div class="container my-5">
	<div class="card shadow p-3 mb-5 bg-body-tertiary rounded">
		<div class="card-body">
			<h3 class="text-center mb-4">Detalhes da inscrição</h3>
			<form id="frmInscricaoDetalha" 
						class="recaptcha-form" 
						method="POST" 
						data-sitekey="<?php echo Config::GOOGLE_RECAPTCHA_SITE_KEY; ?>"
						data-url="acoes/confirmar_inscricao_detalhas.php"
						onsubmit="return fncValidaFormularioDetalhar(event);">
				<input type="hidden" id="idCadastro" name="idCadastro" value="<?php echo $idCadastro; ?>">
				<div class="mb-3 row">
					<label for="Curso" class="col-12 col-sm-4 col-form-label text-sm-end">Curso em que deseja se inscrever:</label>
					<div class="col-sm-8">
						<?php
							$cont = 0;
							$sql = "SELECT
												cc.idRelCursoCadastro,
												ca.idCadastro,
												cr.idCurso,
												cr.nomeCurso,
												cr.status,
												CASE WHEN cc.idSituacao IS NULL THEN 0 ELSE cc.idSituacao END AS idSituacao,
												CASE WHEN cc.idRelCursoCadastro IS NULL THEN false ELSE true END AS realizado
											FROM tbl_cadastro ca
											CROSS JOIN tbl_curso cr
											LEFT JOIN tbl_curso_cadastro cc ON ca.idCadastro = cc.idCadastro AND cr.idCurso = cc.idCurso
											WHERE (cr.status = 1 AND ca.idCadastro = $idCadastro)
											ORDER BY cr.nomeCurso ASC;";

							$resultado = mysqli_query($conn, $sql);

							while($rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {
								$idCurso = $rs["idCurso"];
								$nomeCurso = $rs["nomeCurso"];
								$realizado = $rs["realizado"];
								$idSit = $rs["idSituacao"];
						?>
							<div class="p-1">
								<!-- <div class="col-sm-4"> -->
										<select class="form-select w-25 id="relCursoCadastro<?php echo $idCurso; ?>" name="relCursoCadastro<?php echo $idCurso; ?>" > 	<!-- onchange="fncRelCursoCadastro('<?php echo $idCurso; ?>','<?php echo $idCadastro; ?>');" -->
										<option value="1" <?php if($realizado == 1) echo 'selected'; ?>>Inscrito</option>
										<option value="2" <?php if($realizado == 0) echo 'selected'; ?>>Inscrever-se</option>
									</select>
									<label class="form-label"><?php echo $nomeCurso; ?></label>
								<!-- </div> -->
								<?php if ($realizado == 0): ?>
								<!-- <div class="col-sm-4"> -->
									- <span class="text-danger">Curso Não realizado.</span>
								<!-- </div> -->
								<?php else: ?>
								<!-- <div class="col-sm-4"> onchange="fncSituacao('<?php echo $idCadastro . '_' . $idCurso; ?>','<?php echo $idCurso; ?>','<?php echo $idCadastro; ?>');"-->
									<select class="form-select w-25" id="situacao<?php echo $idCadastro . '_' . $idCurso; ?>" name="situacao<?php echo $idCadastro . '_' . $idCurso; ?>" >
										<option value="">Selecione</option>
										<?php
											$sql1 = "SELECT idSituacao, nomeSituacao FROM tbl_situacao_aluno ORDER BY idSituacao ASC;";
											$resultado1 = mysqli_query($conn, $sql1);
											while($rs1 = mysqli_fetch_array($resultado1, MYSQLI_ASSOC)) {
										?>
											<option value="<?php echo $rs1["idSituacao"]; ?>" <?php if ($rs1["idSituacao"] == $idSit) echo "selected"; ?>>
												<?php echo $rs1["nomeSituacao"]; ?>
											</option>
										<?php } ?>
									</select>
								<!-- </div> -->
								<?php endif; ?>
							</div>
							<hr>
						<?php $cont++; } ?>
					</div>
				</div>
				<div class="mb-3 row">
					<label for="Matricula" class="col-12 col-sm-4 col-form-label text-sm-end">Inscrição:</label>
					<div class="col-sm-4 col-sm-3">
						<input type="text" class="form-control" id="Matricula" name="Matricula"
							value="<?php echo $inscricao; ?>" readonly disabled>
					</div>
				</div>
				<div class="row mb-3">
					<label for="Nome" class="col-12 col-sm-4 col-form-label text-sm-end">Nome completo:</label>
					<div class="col-12 col-sm-8 col-md-7">
						<input type="text" class="form-control text-start" id="Nome" name="Nome" maxlength="100"
							value="<?php echo $nome; ?>">
					</div>
				</div>
				<div class="row mb-3">
					<label for="DatadeNacimento" class="col-12 col-sm-4 col-form-label text-sm-end">Data de Nascimento:</label>
					<div class="col-12 col-sm-8 col-md-6 col-lg-3">
						<input type="text" class="form-control" id="DatadeNacimento" name="DatadeNacimento" maxlength="10"
							value="<?php echo $dataDeNacimento; ?>" disabled>
					</div>
				</div>
				<!-- Telefones -->
				<div class="row mb-3">
					<label for="TelResidencial" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Residencial: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" name="TelResidencial" id="TelResidencial" maxlength="20" value="<?php echo $telResidencial; ?>">
						<small class="form-text text-muted">Ex.: 00 (00) 0000-0000</small>
						<div class="invalid-feedback">Preencha o telefone residencial.</div>
					</div>
				</div>
				<div class="row mb-3">
					<label for="TelTrabalho" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Trabalho:</label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" name="TelTrabalho" id="TelTrabalho" maxlength="20" value="<?php echo $telTrabalho; ?>">
					</div>
				</div>
				<div class="row mb-3">
					<label for="TelCelular" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Celular: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" name="TelCelular" id="TelCelular" maxlength="20" value="<?php echo $telCelular; ?>">
						<small class="form-text text-muted">Ex.: 00 (00) 00000-0000</small>
						<div class="invalid-feedback">Preencha o telefone celular.</div>
					</div>
				</div>		
				<!-- E-mail -->
				<div class="mb-3 row">
					<label for="Email" class="col-12 col-sm-4 col-form-label text-sm-end">E-mail: <span class="text-danger">*</span></label>
					<div class="col-md-6">
						<input type="email" class="form-control" name="Email" id="Email" maxlength="50" value="<?php echo $email; ?>">
						<div class="invalid-feedback">Preencha o e-mail.</div>
					</div>
				</div>
				<!-- Confirmar E-mail -->
				<div class="row mb-3">
					<label for="ConfirmarEmail" class="col-12 col-sm-4 col-form-label text-sm-end">Confirmar E-mail: <span class="text-danger">*</span></label>
					<div class="col-md-6">
						<input type="email" class="form-control" name="ConfirmarEmail" id="ConfirmarEmail" maxlength="50" value="<?php echo $confirmarEmail; ?>">
						<div class="invalid-feedback">Preencha a confirmar e-mail.</div>
					</div>
				</div>
				<!-- Nacionalidade -->
				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">
						Para a matrícula, precisamos que responda à pergunta: Sua nacionalidade é brasileira? <span class="text-danger">*</span>
					</label>
					<div class="col-sm-8 pt-2 text-start">
						<div class="form-check form-check-inline">
							<input class="form-check-input" type="radio" name="Nacionalidade" id="nacionalidade_1" value="1"
								onclick="fncHabilitaCampoIdentificador(1, '', '');" <?php if($nacionalidade == 1){ echo "checked"; } ?>>
							<label class="form-check-label" for="nacionalidade_1">Sim</label>
						</div>
						<div class="form-check form-check-inline">
							<input class="form-check-input" type="radio" name="Nacionalidade" id="nacionalidade_2" value="2"
								onclick="fncHabilitaCampoIdentificador(2,'', '');" <?php if($nacionalidade == 2){ echo "checked"; } ?>>
							<label class="form-check-label" for="nacionalidade_2">Não</label>
						</div>
					</div>
				</div>
				<!-- Campo Identificador é dinâmico via JS -->
				<div id="campoIdentificador"></div>
				<!-- CEP + botão -->
				<div class="mb-3 row">
					<label for="cep" class="col-12 col-sm-4 col-form-label text-sm-end">CEP: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4">
						<div class="input-group">
							<input type="text" class="form-control" id="cep" name="cep" maxlength="10" value="<?php echo $cep; ?>" />
							<button type="button" class="btn btn-primary" onclick="buscarCep(this.value);">Pesquisar CEP</button>
						</div>
						<small class="text-muted">Ex.: 00000-000</small>
						<div class="invalid-feedback">Preencha o CEP.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Pais" class="col-12 col-sm-4 col-form-label text-sm-end">País <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-3">
						<input type="text" class="form-control" name="Pais" id="Pais" maxlength="50" value="<?php echo $pais; ?>">
						<div class="invalid-feedback">Preencha o país.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Endereco" class="col-12 col-sm-4 col-form-label text-sm-end">Endereço <span class="text-danger">*</span></label>
					<div class="col-sm-8">
						<input type="text" class="form-control" name="Endereco" id="Endereco" maxlength="150" value="<?php echo $endereco; ?>">
						<div class="invalid-feedback">Preencha o endereço.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Complemento" class="col-12 col-sm-4 col-form-label text-sm-end">Complemento</label>
					<div class="col-12 col-sm-8 col-md-5">
						<input type="text" class="form-control" name="Complemento" id="Complemento" maxlength="200" value="<?php echo $complemento; ?>">
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Cidade" class="col-12 col-sm-4 col-form-label text-sm-end">Cidade <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-5">
						<input type="text" class="form-control" name="Cidade" id="Cidade" maxlength="50" value="<?php echo $cidade; ?>">
						<div class="invalid-feedback">Preencha a cidade.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Bairro" class="col-12 col-sm-4 col-form-label text-sm-end">Bairro <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-5">
						<input type="text" class="form-control" name="Bairro" id="Bairro" maxlength="50" value="<?php echo $bairro; ?>">
						<div class="invalid-feedback">Preencha o bairro.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="UF" class="col-12 col-sm-4 col-form-label text-sm-end text-uppercase">UF <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" name="UF" id="UF" maxlength="2" value="<?php echo $uf; ?>">
						<div class="invalid-feedback">Preencha o UF.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="QuantoTemponaDoutrina" class="col-12 col-sm-4 col-form-label text-sm-end">Quanto tempo na doutrina?</label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" name="QuantoTemponaDoutrina" id="QuantoTemponaDoutrina" maxlength="50" value="<?php echo $quantoTempoNaDoutrina; ?>">
					</div>
				</div>

				<div class="mb-3 row">
					<label for="AtividadeProfissiona" class="col-12 col-sm-4 col-form-label text-sm-end">Atividade profissional</label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" name="AtividadeProfissiona" id="AtividadeProfissiona" maxlength="50" value="<?php echo $atividadeProfissional; ?>">
					</div>
				</div>

				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">Escolaridade <span class="text-danger">*</span></label>
					<div class="col-sm-8">
						<div class="form-check">
							<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_0" value="Fundamental" <?php if($escolaridade == "Fundamental"){ echo "checked"; } ?>>
							<label class="form-check-label" for="Escolaridade_0">Fundamental</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_1" value="Secundária" <?php if($escolaridade == "Secundária"){ echo "checked"; } ?>>
							<label class="form-check-label" for="Escolaridade_1">Secundária</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_2" value="Universitária" <?php if($escolaridade == "Universitária"){ echo "checked"; } ?>>
							<label class="form-check-label" for="Escolaridade_2">Universitária</label>
						</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">
						Dispõe de 5 horas por semana aprox. para o curso? <span class="text-danger">*</span>
					</label>
					<div class="col-sm-8">
						<div class="form-check">
							<input class="form-check-input" type="radio" name="DispoeSemana" id="dispoeSemana_0" value="1"
								<?php if($dispoeSemana == 1){ echo "checked"; } ?>>
							<label class="form-check-label" for="dispoeSemana_0">Sim</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="radio" name="DispoeSemana" id="dispoeSemana_1" value="0"
								onclick="fncNaoDispoetempo();" <?php if($dispoeSemana == 0){ echo "checked"; } ?>>
							<label class="form-check-label" for="dispoeSemana_1">Não</label>
						</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">
						Compromete-se a deixar o curso apenas por força maior? <span class="text-danger">*</span>
					</label>
					<div class="col-sm-8">
						<div class="form-check">
							<input class="form-check-input" type="radio" name="ProblemaForcaMaior" id="problemaForcaMaior_0" value="1"
								<?php if($problemaForcaMaior == 1){ echo "checked"; } ?>>
							<label class="form-check-label" for="problemaForcaMaior_0">Sim</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="radio" name="ProblemaForcaMaior" id="problemaForcaMaior_1" value="0"
								onclick="fncProblemaDeForcaMaior();" <?php if($problemaForcaMaior == 0){ echo "checked"; } ?>>
							<label class="form-check-label" for="problemaForcaMaior_1">Não</label>
						</div>
					</div>
				</div>
				<!-- Botões  onclick="fncValidaFormularioDetalhar();"-->
				<div class="text-center">
					<button type="submit" class="btn btn-primary" id="enviar" name="enviar">Enviar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php
	//Liberar o conjunto de resultados
	mysqli_free_result($resultado);
	//Fecha a conexão com o banco
	mysqli_close($conn);

	require_once("includes/rodape.php");
?>

<script>
	$(document).ready(function () {
		fncHabilitaCampoIdentificador(<?php echo $nacionalidade; ?>, '<?php echo ($nacionalidade != 0 ? $identificacao : ''); ?>', 'readonly');
	});
</script>