<?php  
	session_start();

	header("Content-Type: text/html; charset=utf-8", true);

	require_once("includes/conexao.php");
	require("includes/funcoes.php");
	require("includes/cabecalho.php");
	require("includes/configGoogle.php");

	//Tipo de validação cadastro ou consulta.
	$tipo = isset($_REQUEST["tipo"]) ? $_REQUEST["tipo"] : "";

	//If para carregar a tela de recuperação de dados do aluno.
	if($tipo == 'E') {

?>

	<div class="container my-5">
		<div class="card shadow p-3 mb-5 bg-body-tertiary rounded">
			<div class="card-body">
				<h3 class="text-center mb-4">Inscrição para um novo curso</h3>
				<p class="text-center text-danger mb-1"><span class="text-danger">*</span> Utilize seu nome como constou do(s) curso(s) já realizados.</p>
				<p class="text-center text-danger"><span class="text-danger">*</span> Ou utilize seu e-mail como constou dos cursos já realizados.</p>
				<form id="frmLoginInscricaoExistente"
							class="recaptcha-form" 
							method="POST" 
							data-sitekey="<?php echo Config::GOOGLE_RECAPTCHA_SITE_KEY; ?>"
							data-url="acoes/confirmar_inscricao.php"
							onsubmit="return fncValidarInscricaoExistente(event);">
					<div class="row mb-3">
						<label for="Nome" class="col-12 col-sm-4 col-form-label text-sm-end">Nome completo:</label>
						<div class="col-md-5">
							<input type="text" class="form-control" id="NomeExistente" name="NomeExistente" maxlength="100" />
							<div class="invalid-feedback">Preencha o nome.</div>
						</div>
					</div>
					<div class="row mb-3">
						<label for="Email" class="col-12 col-sm-4 col-form-label text-sm-end">E-mail:</label>
						<div class="col-md-5">
							<input type="email" class="form-control" id="EmailExistente" name="EmailExistente" maxlength="50" />
							<div class="invalid-feedback">Preencha o e-mail.</div>
						</div>
					</div>
					<div class="text-center">
						<button type="submit" class="btn btn-primary">Enviar</button>
					</div>
				</form>	
			</div>
		</div>
	</div>

<?php

	} else {
		
	if (!isset($_SESSION['__inscricao'])) {
    header("Location: ../frm_inscricao_existente.php?tipo=E");
    exit;
	}

	// Tipo de ação da página (usado mais adiante no código)
	$tipoAcao = isset($_GET["tipo"]) ? $_GET["tipo"] : "";

	// Sanitiza e valida o ID recebido
	$id = isset($_GET["id"]) ? (int) $_GET["id"] : 0;

	// Verifica se o ID é válido
	if ($id <= 0) {
		die("ID inválido.");
	}

	// Query melhorada: Sem joins desnecessários nem GROUP BY
	$sql = "SELECT 
						C.idCadastro,
						C.inscricao,
						C.nome,
						C.dataNacimento,
						C.telResidencial,
						C.telTrabalho,
						C.telCelular,
						C.email,
						C.confirmarEmail,
						C.pais,
						C.endereco,
						C.complemento,
						C.bairro,
						C.cidade,
						C.uf,
						C.cep,
						C.qtTempDoutrina,
						C.atividadeProf,
						C.dispoeSemana,
						C.problemaForcaMaior,
						C.escolaridade,
						C.identificacao,
						C.nacionalidade
				FROM tbl_cadastro C
				INNER JOIN tbl_curso_cadastro CC on (C.idCadastro = CC.idCadastro)
				INNER JOIN tbl_curso CUR on (CUR.idCurso = CC.idCurso)
				WHERE C.idCadastro = $id
				LIMIT 1;";

	// Executa a query
	$resultado = mysqli_query($conn, $sql);

	// if (!$resultado) {
	// 	die("Erro na consulta: " . mysqli_error($conn));
	// }

	// Busca o resultado
	$rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC);

	if (!$rs) {
		die("Cadastro não encontrado.");
	}

	//Variáveis
	$idCadastro = $rs["idCadastro"];
	$inscricao = $rs["inscricao"];
	$nome = $rs["nome"];
	$dataDeNacimento = $rs["dataNacimento"];
	$telResidencial = $rs["telResidencial"];
	$telTrabalho = $rs["telTrabalho"];
	$telCelular = $rs["telCelular"];
	$email = $rs["email"];
	$confirmarEmail = $rs["confirmarEmail"];
	$pais = $rs["pais"];
	$endereco = $rs["endereco"];
	$complemento = $rs["complemento"];
	$bairro = $rs["bairro"];
	$uf = $rs["uf"];
	$cidade = $rs["cidade"];
	$cep = $rs["cep"];
	$quantoTempoNaDoutrina = $rs["qtTempDoutrina"];
	$atividadeProfissional = $rs["atividadeProf"];
	$dispoeSemana = $rs["dispoeSemana"];
	$problemaForcaMaior = $rs["problemaForcaMaior"];
	$escolaridade = $rs["escolaridade"];
	$identificacao = $rs["identificacao"];
	ECHO $nacionalidade = $rs["nacionalidade"];
?>

	<div class="container my-5">
		<div class="card shadow p-3 mb-5 bg-body-tertiary rounded">
			<div class="card-body">
				<h3 class="text-center mb-4">Nova inscrição para quem já fez algum curso anteriormente</h3>
				<form id="frmInscricaoExistente" 
							class="recaptcha-form" 
							method="POST" 
							data-sitekey="<?php echo Config::GOOGLE_RECAPTCHA_SITE_KEY; ?>"
							data-url="acoes/atualizar_inscricao.php"
							onsubmit="return fncValidaFormularioExistente(event);"> 
					<input type="hidden" id="idCadastro" name="idCadastro" value="<?php echo htmlspecialchars($idCadastro); ?>" />
					<div class="mb-3 row">
						<label class="col-12 col-sm-4 col-form-label text-sm-end">Curso em que deseja se inscrever:</label>
						<div class="col-sm-8">
							<?php  
								$cont = 0;
								$sql = "SELECT 
													cc.idRelCursoCadastro,
													ca.idCadastro,
													cr.idCurso,
													cr.nomeCurso,
													cr.status,
													CASE WHEN cc.idSituacao IS NULL THEN 0 ELSE cc.idSituacao END AS idSituacao,
													CASE WHEN cc.idRelCursoCadastro IS NULL THEN false ELSE true END AS realizado
												FROM tbl_cadastro ca
												CROSS JOIN tbl_curso cr
												LEFT JOIN tbl_curso_cadastro cc ON ca.idCadastro = cc.idCadastro AND cr.idCurso = cc.idCurso
												WHERE (cr.status = 1 AND ca.idCadastro = $idCadastro)
												ORDER BY cr.nomeCurso ASC;";

								$resultado = mysqli_query($conn, $sql);

								while($rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {  
									$idCurso = $rs["idCurso"];
									$nomeCurso = $rs["nomeCurso"];
									$realizado = $rs["realizado"];
									$idSituacao = $rs["idSituacao"];
							?>
							<div class="form-check">
								<?php if (!$realizado) { ?>
									<input class="form-check-input" type="radio" name="Curso" id="curso_<?php echo $cont; ?>" value="<?php echo $idCurso; ?>">
									<label class="form-check-label" for="curso_<?php echo $cont; ?>"><?php echo $nomeCurso; ?> - <span class="text-danger">Curso Não realizado.</span></label>
								<?php } else {
									$sql1 = "SELECT idSituacao, nomeSituacao FROM tbl_situacao_aluno ORDER BY idSituacao ASC;";
									$resultado1 = mysqli_query($conn, $sql1);
									while($rs1 = mysqli_fetch_array($resultado1, MYSQLI_ASSOC)) {
										if ($rs1["idSituacao"] == $idSituacao) {
											echo "<label class='form-label'>$nomeCurso - <span class='text-primary'>{$rs1['nomeSituacao']}</span></label><br>";
										}
									}
								} ?>
							</div>
							<?php $cont++; } ?>
						</div>
					</div>
					<!-- Linha: Inscrição e Nome -->
					<div class="mb-3 row">
						<label for="Matricula" class="col-12 col-sm-4 col-form-label text-sm-end">Inscrição:</label>
						<div class="col-sm-4 col-sm-3">
							<input type="text" class="form-control" name="Matricula" id="Matricula" maxlength="15" value="<?php echo $inscricao; ?>" disabled readonly>
						</div>
					</div>
					<!-- Nome -->
					<div class="row mb-3">
						<label for="Nome" class="col-12 col-sm-4 col-form-label text-sm-end">Nome:</label>
						<div class="col-12 col-sm-8 col-md-7">
							<input type="text" class="form-control" name="Nome" id="Nome" maxlength="100" value="<?php echo $nome; ?>" disabled>
							<div class="invalid-feedback">Preencha o nome.</div>
						</div>
					</div>
					<!-- Data de Nascimento -->
					<div class="row mb-3">
						<label for="DatadeNacimento" class="col-12 col-sm-4 col-form-label text-sm-end">Data de Nascimento:</label>
						<div class="col-12 col-sm-8 col-md-6 col-lg-3">
							<input type="text" class="form-control" name="DatadeNacimento" id="DatadeNacimento" maxlength="10" value="<?php echo $dataDeNacimento; ?>" disabled>
						</div>
					</div>
					<!-- Telefones -->
					<div class="row mb-3">
						<label for="TelResidencial" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Residencial: <span class="text-danger">*</span></label>
						<div class="col-12 col-sm-8 col-md-4 col-lg-2">
							<input type="text" class="form-control" name="TelResidencial" id="TelResidencial" maxlength="20" value="<?php echo $telResidencial; ?>">
							<small class="form-text text-muted">Ex.: 00 (00) 0000-0000</small>
							<div class="invalid-feedback">Preencha o telefone residencial.</div>
						</div>
					</div>
					<div class="row mb-3">
						<label for="TelTrabalho" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Trabalho:</label>
						<div class="col-12 col-sm-8 col-md-4 col-lg-2">
							<input type="text" class="form-control" name="TelTrabalho" id="TelTrabalho" maxlength="20" value="<?php echo $telTrabalho; ?>">
						</div>
					</div>
					<div class="row mb-3">
						<label for="TelCelular" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Celular: <span class="text-danger">*</span></label>
						<div class="col-12 col-sm-8 col-md-4 col-lg-2">
							<input type="text" class="form-control" name="TelCelular" id="TelCelular" maxlength="20" value="<?php echo $telCelular; ?>">
							<small class="form-text text-muted">Ex.: 00 (00) 00000-0000</small>
							<div class="invalid-feedback">Preencha o telefone celular.</div>
						</div>
					</div>			
					<!-- E-mail -->
					<div class="mb-3 row">
						<label for="Email" class="col-12 col-sm-4 col-form-label text-sm-end">E-mail: <span class="text-danger">*</span></label>
						<div class="col-md-6">
							<input type="email" class="form-control" name="Email" id="Email" maxlength="50" value="<?php echo $email; ?>">
							<div class="invalid-feedback">Preencha o e-mail.</div>
						</div>
					</div>
					<!-- Confirmar E-mail -->
					<div class="row mb-3">
						<label for="ConfirmarEmail" class="col-12 col-sm-4 col-form-label text-sm-end">Confirmar E-mail: <span class="text-danger">*</span></label>
						<div class="col-md-6">
							<input type="email" class="form-control" name="ConfirmarEmail" id="ConfirmarEmail" maxlength="50" value="<?php echo $confirmarEmail; ?>">
							<div class="invalid-feedback">Preencha a confirmar e-mail.</div>
						</div>
					</div>
					<!-- Nacionalidade -->
					<div class="mb-3 row">
						<label class="col-12 col-sm-4 col-form-label text-sm-end">Sua nacionalidade é brasileira? <span class="text-danger">*</span></label>
						<div class="col-sm-8">
							<div class="form-check text-start">
								<input class="form-check-input" type="radio" name="Nacionalidade" id="nacionalidade_1" value="1" onclick="fncHabilitaCampoIdentificador(1, '', '');" <?php echo $nacionalidade == 1 ? "checked" : ""; ?> disabled>
								<label class="form-check-label" for="nacionalidade_1">Sim</label>
							</div>
							<div class="form-check">
								<input class="form-check-input" type="radio" name="Nacionalidade" id="nacionalidade_2" value="2" onclick="fncHabilitaCampoIdentificador(2, '', '');" <?php echo $nacionalidade == 2 ? "checked" : ""; ?> disabled>
								<label class="form-check-label" for="nacionalidade_2">Não</label>
							</div>
							<div id="erroNacionalidade" class="invalid-feedback d-none">Selecione a nacionalidade.</div>
						</div>
					</div>
					<!-- Identificador -->
					<div style="display: inline" id="campoIdentificador"></div>
					<!-- CEP + botão -->
					<div class="mb-3 row">
						<label for="cep" class="col-12 col-sm-4 col-form-label text-sm-end">CEP: <span class="text-danger">*</span></label>
						<div class="col-12 col-sm-8 col-md-4">
							<div class="input-group">
								<input type="text" class="form-control" name="cep" id="cep" maxlength="10" value="<?php echo $cep; ?>">
								<button type="button" class="btn btn-primary" onclick="buscarCep(this.value);">Pesquisar CEP</button>
							</div>
							<small class="text-muted">Ex.: 00000-000</small>
							<div class="invalid-feedback">Preencha o CEP.</div>
						</div>
					</div>

					<div class="mb-3 row">
						<label for="Pais" class="col-12 col-sm-4 col-form-label text-sm-end">País: <span class="text-danger">*</span></label>
						<div class="col-12 col-sm-8 col-md-4 col-lg-3">
							<input type="text" class="form-control" name="Pais" id="Pais" maxlength="50" value="<?php echo $pais; ?>">
							<div class="invalid-feedback">Preencha o país.</div>
						</div>
					</div>

					<div class="mb-3 row">
						<label for="Endereco" class="col-12 col-sm-4 col-form-label text-sm-end">Endereço: <span class="text-danger">*</span></label>
						<div class="col-sm-8">
							<input type="text" class="form-control" name="Endereco" id="Endereco" maxlength="150" value="<?php echo $endereco; ?>">
							<div class="invalid-feedback">Preencha o endereço.</div>
						</div>
					</div>

					<div class="mb-3 row">
						<label for="Complemento" class="col-12 col-sm-4 col-form-label text-sm-end">Complemento:</label>
						<div class="col-12 col-sm-8 col-md-5">
							<input type="text" class="form-control" name="Complemento" id="Complemento" maxlength="500" value="<?php echo $complemento; ?>">
						</div>
					</div>

					<div class="mb-3 row">
						<label for="Cidade" class="col-12 col-sm-4 col-form-label text-sm-end">Cidade: <span class="text-danger">*</span></label>
						<div class="col-12 col-sm-8 col-md-5">
							<input type="text" class="form-control" name="Cidade" id="Cidade" maxlength="50" value="<?php echo $cidade; ?>">
							<div class="invalid-feedback">Preencha a cidade.</div>
						</div>
					</div>

					<div class="mb-3 row">
						<label for="Bairro" class="col-12 col-sm-4 col-form-label text-sm-end">Bairro: <span class="text-danger">*</span></label>
						<div class="col-12 col-sm-8 col-md-5">
							<input type="text" class="form-control" name="Bairro" id="Bairro" maxlength="50" value="<?php echo $bairro; ?>">
							<div class="invalid-feedback">Preencha o bairro.</div>
						</div>
					</div>

					<div class="mb-3 row">
						<label for="UF" class="col-12 col-sm-4 col-form-label text-sm-end text-uppercase">UF: <span class="text-danger">*</span></label>
						<div class="col-12 col-sm-8 col-md-4 col-lg-2">
							<input type="text" class="form-control text-uppercase" name="UF" id="UF" maxlength="2" value="<?php echo $uf; ?>">
							<div class="invalid-feedback">Preencha o UF.</div>
						</div>
					</div>

					<div class="mb-3 row">
						<label for="QuantoTemponaDoutrina" class="col-12 col-sm-4 col-form-label text-sm-end">Quanto tempo na doutrina?</label>
						<div class="col-12 col-sm-8 col-md-4 col-lg-2">
							<input type="text" class="form-control" name="QuantoTemponaDoutrina" id="QuantoTemponaDoutrina" maxlength="50" value="<?php echo $quantoTempoNaDoutrina; ?>">
						</div>
					</div>

					<div class="mb-3 row">
						<label for="AtividadeProfissiona" class="col-12 col-sm-4 col-form-label text-sm-end">Atividade profissional:</label>
						<div class="col-12 col-sm-8 col-md-4 col-lg-2">
							<input type="text" class="form-control" name="AtividadeProfissiona" id="AtividadeProfissiona" maxlength="50" value="<?php echo $atividadeProfissional; ?>">
						</div>
					</div>

					<div class="mb-3 row">
						<label class="col-12 col-sm-4 col-form-label text-sm-end">Escolaridade: <span class="text-danger">*</span></label>
						<div class="col-sm-8">
							<div class="form-check">
								<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_0" value="Fundamental" <?php if ($escolaridade == "Fundamental") echo "checked"; ?>>
								<label class="form-check-label" for="Escolaridade_0">Fundamental</label>
							</div>
							<div class="form-check">
								<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_1" value="Secundária" <?php if ($escolaridade == "Secundária") echo "checked"; ?>>
								<label class="form-check-label" for="Escolaridade_1">Secundária</label>
							</div>
							<div class="form-check">
								<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_2" value="Universitária" <?php if ($escolaridade == "Universitária") echo "checked"; ?>>
								<label class="form-check-label" for="Escolaridade_2">Universitária</label>
							</div>
						</div>
					</div>

					<div class="mb-3 row">
						<label class="col-12 col-sm-4 col-form-label text-sm-end">Dispõe de 5 horas semanais para o curso? <span class="text-danger">*</span></label>
						<div class="col-sm-8">
							<div class="form-check">
								<input class="form-check-input" type="radio" name="DispoeSemana" id="dispoeSemana_0" value="1" <?php if ($dispoeSemana == 1) echo "checked"; ?>>
								<label class="form-check-label" for="dispoeSemana_0">Sim</label>
							</div>
							<div class="form-check">
								<input class="form-check-input" type="radio" name="DispoeSemana" id="dispoeSemana_1" value="0" <?php if ($dispoeSemana == 0) echo "checked"; ?> onclick="fncNaoDispoetempo();">
								<label class="form-check-label" for="dispoeSemana_1">Não</label>
							</div>
						</div>
						<div id="erroDispoeSemana" class="invalid-feedback d-none">Informe sua disponibilidade na semana.</div>
					</div>

					<div class="mb-3 row">
						<label class="col-12 col-sm-4 col-form-label text-sm-end">Compromete-se a deixar o curso apenas por força maior? <span class="text-danger">*</span></label>
						<div class="col-sm-8">
							<div class="form-check">
								<input class="form-check-input" type="radio" name="ProblemaForcaMaior" id="problemaForcaMaior_0" value="1" <?php if ($problemaForcaMaior == 1) echo "checked"; ?>>
								<label class="form-check-label" for="problemaForcaMaior_0">Sim</label>
							</div>
							<div class="form-check">
								<input class="form-check-input" type="radio" name="ProblemaForcaMaior" id="problemaForcaMaior_1" value="0" <?php if ($problemaForcaMaior == 0) echo "checked"; ?> onclick="fncProblemaDeForcaMaior();">
								<label class="form-check-label" for="problemaForcaMaior_1">Não</label>
							</div>
						</div>
					</div>
					<!-- Botão Enviar onclick="fncValidaFormularioExistente();"-->
					<div class="text-center">
						<button type="submit" class="btn btn-primary" id="enviar" name="enviar">Enviar</button>
						<button type="button" class="btn btn-secondary" onclick="fncInscricaoExistente();">Sair</button>
					</div>
				</form>
			</div>
		</div>
	</div>

<?php
	//mysqli_free_result($resultado1);
	mysqli_close($conn);		
}
	require("includes/rodape.php");
?>

<?php  
	//$nacionalidade = 0;
?>

<script>
	$(document).ready(function () {
		fncHabilitaCampoIdentificador(
			<?php echo $nacionalidade ?>,
			'<?php echo $nacionalidade != 0 ? addslashes($identificacao) : ''; ?>',
			'readonly disabled'
    );
	});
</script>