<?php
session_start();
header('Content-Type: text/html; charset=utf-8', true);

if (!isset($_SESSION['__idUsu'])) {
  header("Location: frm_login.php");
  exit;
}

require('includes/conexao.php');
require('includes/funcoes.php');
require('includes/cabecalho.php');
require('includes/menu.php');
?>

<div class="container my-5">
  <div class="card">
    <div class="card-body">
      <h3 class="card-title mb-4">Listagem de inscritos</h3>
        <div class="table-responsive-lg">
          <!-- Filtros personalizados -->
          <div class="row mb-3">
            <div class="col-sm-4">
              <input type="text" id="filtroNome" class="form-control" placeholder="Filtrar por Nome">
            </div>
            <div class="col-sm-4">
              <select id="filtroCurso" class="form-select mb-0">
                <option value="">Todos os Cursos</option>
                <?php
                  $sqlCursos = "SELECT DISTINCT nomeCurso FROM tbl_curso ORDER BY nomeCurso";
                  $resCursos = mysqli_query($conn, $sqlCursos);
                  while ($row = mysqli_fetch_assoc($resCursos)) {
                    echo "<option value=\"{$row['nomeCurso']}\">{$row['nomeCurso']}</option>";
                  }
                ?>
              </select>
            </div>
            <div class="col-sm-4">
              <select id="filtroSituacao" class="form-select mb-0">
                <option value="">Todas as Situações</option>
                <?php
                  $sqlSit = "SELECT DISTINCT nomeSituacao FROM tbl_situacao_aluno ORDER BY nomeSituacao";
                  $resSit = mysqli_query($conn, $sqlSit);
                  while ($row = mysqli_fetch_assoc($resSit)) {
                    echo "<option value=\"{$row['nomeSituacao']}\">{$row['nomeSituacao']}</option>";
                  }
                ?>
              </select>
            </div>
          </div>
          <!-- Botão Excel -->
          <div class="row mb-3">
            <div class="col-sm-4">
              <button type="button" class="btn btn-success w-100" onclick="fncGerarExcel()">Gerar relatório em Excel</button>
            </div>
          </div>
          <table id="tblInscricao" class="table table-bordered table-hover align-middle text-center">
            <thead class="table-light">
              <tr>
                <th class="text-center">Nº</th>
                <th class="text-center">Inscrição</th>
                <th class="text-right">Nome</th>
                <th class="text-right">E-mail</th>
                <th class="text-center">Cidade</th>
                <th class="text-center">UF</th>
                <th class="text-right">Curso</th>
                <th class="text-center">Data</th>
                <th class="text-center">Situação</th>
                <th class="text-center">Ações</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
    </div>
  </div>
</div>

<?php
	mysqli_close($conn);
	require("includes/rodape.php");
?>
