<?php
  session_start();

	require_once("includes/conexao.php");
	require("includes/funcoes.php");
	require("includes/cabecalho.php");
  require("includes/configGoogle.php");
?>

<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-6 col-lg-4">
      <div class="card mt-5 shadow-sm">
        <div class="card-body">
          <h3 class="card-title text-center mb-4">Área de Login</h3>
          <form id="frmLogin"						
                class="recaptcha-form" 
                method="POST" 
                data-sitekey="<?php echo Config::GOOGLE_RECAPTCHA_SITE_KEY; ?>"
                data-url="acoes/logar.php" 
                onsubmit="return fncLogin(event);">
            <div class="mb-3">
              <label for="login" class="form-label">Login:</label>
              <input type="text" id="login" name="login" class="form-control" placeholder="Digite seu login">
              <div class="invalid-feedback">Por favor, informe seu login.</div>
            </div>
            <div class="mb-3">
              <label for="senha" class="form-label">Senha:</label>
              <input type="password" id="senha" name="senha" class="form-control" placeholder="Digite sua senha">
              <div class="invalid-feedback">Por favor, informe sua senha.</div>
            </div>
            <div class="form-check mb-3">
              <input class="form-check-input" type="checkbox" id="lembrarLogin">
              <label class="form-check-label" for="lembrarLogin">Lembrar login</label>
            </div>
            <div class="d-grid">
              <button type="submit" class="btn btn-primary">Enviar</button>
            </div>
            <div id="mensagemErro" class="alert alert-danger mt-3 text-center d-none"></div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<?php
	require("includes/rodape.php");
?>