<?php
	session_start();
	header("Content-Type: text/html; charset=iso-8859-1",true);
	require('includes/conexao.php');
	require("includes/funcoes.php");
	require("includes/cabecalho.php");
	require("includes/menu.php");

	//Verifica se existe a session.
	if(isset($_SESSION['__idUsu'])){

		//resposta 2: problema - 1: gravou - 0: Não existe 
		$r = (isset($_GET['r']) ? $_GET['r'] : 0); 

		//variável que recebe o id de ordenação ap�s evento do onchange e recarrega a página.
		$ordena = (isset($_POST["ordena"]) ? $_POST["ordena"] : ""); 

		//variável que recebe 
		$nome = (isset($_POST["nome"]) ? $_POST["nome"] : "");
?>

	<div class="container mt-4">
		<div class="card shadow-sm">
			<div class="card-header bg-primary text-white">
				<h5 class="mb-0">Listagem de Inscritos</h5>
			</div>
			<div class="card-body">
				<form id="frm_pesquisa" name="frm_pesquisa" action="frm_pesquisa.php" method="post">
					<div class="container mt-4">
						<div class="card shadow-sm">
							<div class="card-header bg-primary text-white">
								<h5 class="mb-0">Pesquisar Inscritos</h5>
							</div>
			
							<?php include("includes/validacao.php"); ?>
						
							<div class="row mb-3">
								<div class="col-md-6">
									<label for="situacao" class="form-label">Situação:</label>
									<select id="situacao" name="situacao" class="form-select">
										<option value="">Selecione</option>
										<?php
											$sql = "SELECT idSituacao, nomeSituacao FROM tbl_situacao_aluno ORDER BY idSituacao ASC;";
											$resultado = mysqli_query($conn, $sql);
											while($rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {
										?>
											<option value="<?php echo $rs["idSituacao"]; ?>"><?php echo $rs["nomeSituacao"]; ?></option>
										<?php } ?>
									</select>
								</div>
								<div class="col-md-6">
									<label for="curso" class="form-label">Curso:</label>
									<select id="curso" name="curso" class="form-select">
										<option value="">Selecione</option>
										<?php
											$sql = "SELECT CUR.idCurso, CUR.nomeCurso FROM tbl_curso CUR WHERE CUR.status = 1 ORDER BY CUR.nomeCurso ASC;";
											$resultado = mysqli_query($conn, $sql);
											while($rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {
										?>
											<option value="<?php echo $rs["idCurso"]; ?>"><?php echo $rs["nomeCurso"]; ?></option>
										<?php } ?>
									</select>
								</div>
							</div>
							<div class="row">
								<div class="col-md-12 text-start">
									<button type="submit" class="btn btn-primary">Pesquisar</button>
									<a href="frm_gera_dados_excel.php" class="btn btn-success" title="Gerar relatório em Excel">Gerar relatório em Excel</a>
								</div>
							</div>

							<div class="container mt-4">
								<div class="table-responsive">
									<table class="table table-bordered table-striped align-middle">
										<thead class="table-primary">
											<tr>
												<th scope="col">Nº</th>
												<th scope="col">Nº de Inscrição</th>
												<th scope="col">Nome</th>
												<th scope="col">E-mail</th>
												<th scope="col">Cidade</th>
												<th scope="col">UF</th>
												<th scope="col">Curso</th>
												<th scope="col">Data da Inscrição</th>
												<th scope="col">Situação</th>
												<th scope="col">Ações</th>
											</tr>
										</thead>
										<tbody>
											<?php
											$sql = mysqli_query($conn, "SEU SELECT AQUI"); // Substitua por sua query

											$qtdLinhas = mysqli_num_rows($sql);
											if ($qtdLinhas > 0) {
												while ($linha = mysqli_fetch_object($sql)) {
													$sqlDetalhes = "SELECT 
														CUR.nomeCurso, 
														CUR_CAD.dtCadastroCurso, 
														SIT.nomeSituacao
														FROM tbl_curso_cadastro CUR_CAD
														INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
														INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
														WHERE CUR_CAD.idCadastro = $linha->idCadastro";

													$resultDetalhes = mysqli_query($conn, $sqlDetalhes);

													// Monta os campos extras
													$cursos = [];
													$datas = [];
													$situacoes = [];

													while ($det = mysqli_fetch_assoc($resultDetalhes)) {
														$cursos[] = $det['nomeCurso'];
														$datas[] = formataData($det['dtCadastroCurso']);
														$situacoes[] = $det['nomeSituacao'];
													}
											?>
												<tr>
													<td class="text-center"><?php echo $linha->idCadastro; ?></td>
													<td class="text-center"><?php echo $linha->inscricao; ?></td>
													<td><?php echo $linha->nome; ?></td>
													<td><?php echo $linha->email; ?></td>
													<td><?php echo fncConvPrimeiraPalavraMaiuscula($linha->cidade); ?></td>
													<td class="text-center"><?php echo $linha->uf; ?></td>
													<td><?php echo implode('<br>', $cursos); ?></td>
													<td class="text-center"><?php echo implode('<br>', $datas); ?></td>
													<td><?php echo implode('<br>', $situacoes); ?></td>
													<td class="text-center">
														<a href="frm_inscricao_detalhas.php?id=<?php echo $linha->idCadastro; ?>&acao=e" class="btn btn-sm btn-outline-primary" title="Editar">
															<i class="bi bi-pencil"></i>
														</a>
														<!-- Exemplo botão excluir (comentado)
														<a href="#" onclick="ExcluirAluno(<?php echo $linha->idCadastro; ?>);" class="btn btn-sm btn-outline-danger" title="Excluir">
															<i class="bi bi-trash"></i>
														</a>
														-->
													</td>
												</tr>
											<?php
												}
											} else {
												echo "<tr><td colspan='10' class='text-center'>Não há inscrições realizadas!</td></tr>";
											}
											?>
										</tbody>
									</table>
								</div>
							</div>
					
						</div>
					</div>
				</form>
			</div>
			<div class="card-footer text-muted text-end">
				<!-- rodapé opcional -->
			</div>
		</div>
	</div>

<?php
		//Fecha a conexão com o banco
		mysqli_close($conn);	

	}else{
		header("Location: frm_login.php");
	}

	require("includes/rodape.php");
?>