<?php

	/** Error reporting */

	error_reporting(E_ALL);
	ini_set('display_errors', TRUE);
	ini_set('display_startup_errors', TRUE);
	date_default_timezone_set('Brazil/East');
	ini_set('log_errors', TRUE);
	ini_set('html_errors' , TRUE);
	ini_set('error_log', dirname(__FILE__) . '/error_log.txt');

	require('includes/conexao.php');
	require('includes/funcoes.php');

	//ConfigurAçães header para forçar o download do arquivo:
	header('Content-type: application/x-msexcel; charset=iso-8859-1');
	//Este cabealho abaixo, indica que o arquivo dever ser gerado para download.
	header('Content-Disposition: attachment; filename=RelatorioParaMatricula.xls');
	//No cache, ou seja, no guarda cache, pois gerado dinamicamente
	header('Pragma: cache');
	header('Cache-Control: cache, must-revalidate');

	//Query para retornar todos os matriculas. 

	$sql = 'SELECT DISTINCT c.idCadastro, c.username, c.nome, c.email
			FROM tbl_cadastro c
			INNER JOIN tbl_curso_cadastro cc on (c.idCadastro = cc.idCadastro)
			INNER JOIN tbl_situacao_aluno s on (cc.idSituacao = s.idSituacao)
			WHERE cc.dtCadastroCurso > "2015-09-09"
			ORDER BY c.nome ASC';

	$resultado = mysqli_query($conn, $sql)or die(mysql_error());

	//---------------------------------------------

	// Criamos uma tabela HTML com o formato da planilha
	$html = '';
	$html .= "<table border='0'>";
	$html .= "	<tr style='font-size: 13px; font-family: Verdana; font-weight: bold; background-color: #E9F7E1;'>";
	$html .= "		<th align='center'>username</th>";
	$html .= "		<th align='center'>password</th>";
	$html .= "		<th align='center'>firstname</th>";
	$html .= "		<th align='center'>lastname</th>";
	$html .= "		<th align='center'>email</th>";
	$html .= "	</tr>";

	$cont = 0;

	while($row=mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {

		$username = $row['username'];
		$password = $row['username'];
		$firstname = fncCopiarPrimeiraNome($row['nome']);
		$lastname = fncCopiarSobreNome($row['nome']);
		$email = $row['email'];

		if($cont%2 == 0) {
			$cor="background-color: #EEF0F1;";
		} else {
			$cor="";
		}	
			$html .= "  <tr style='font-size: 12px; font-family: Tahoma, Verdana; $cor'>";	
			$html .= "	  <td align='center'>$username</td>";
			$html .= "	  <td align='center'>$password</td>";
			$html .= "	  <td align='center'>$firstname</td>";
			$html .= "	  <td align='center'>$lastname</td>";
			$html .= "	  <td align='center'>$email</td>";
			$html .= "  </tr>";	

			$cont++;
	}									

	$html .= "</table>";

	echo $html;

	//Liberar o conjunto de resultados
	mysqli_free_result($resultado);

	//Fecha a conexão com o banco
	mysqli_close($conn);

	exit;

?>