<?php
	session_start();

	header("Content-Type: text/html; charset=utf-8", true);
	
	require('includes/conexao.php');
	require('includes/funcoes.php');
	require('includes/cabecalho.php');
	require('includes/menu.php');

	//Verifica se existe a session.
	if(isset($_SESSION['__idUsu'])) {

		//Variaveis locais
		$sum = 0;

		//Query
		$sql = "SELECT
					SIT.idSituacao,
					SIT.nomeSituacao,
					CUR.status,
					CUR.nomeCurso,
					COUNT(SIT.nomeSituacao) AS total_situacao
				FROM tbl_cadastro CAD
				INNER JOIN tbl_curso_cadastro CUR_CAD ON CAD.idCadastro = CUR_CAD.idCadastro
				INNER JOIN tbl_curso CUR ON CUR.idCurso = CUR_CAD.idCurso
				INNER JOIN tbl_situacao_aluno SIT ON SIT.idSituacao = CUR_CAD.idSituacao
				WHERE SIT.idSituacao IN (1, 2, 3, 4)
				GROUP BY SIT.idSituacao, CUR.nomeCurso
				ORDER BY SIT.idSituacao, CUR.nomeCurso ASC;";

		//Executa a query e retorna;
		$resultado = mysqli_query($conn, $sql);

		//Query
		$sql1 = "SELECT 
					SIT.nomeSituacao,
					COUNT(SIT.nomeSituacao) AS situacao
				FROM tbl_cadastro CAD
				INNER JOIN tbl_curso_cadastro CUR_CAD on (CAD.idCadastro = CUR_CAD.idCadastro)
				INNER JOIN tbl_curso CUR ON (CUR.idCurso = CUR_CAD.idCurso)
				INNER JOIN tbl_situacao_aluno SIT on (SIT.idSituacao = CUR_CAD.idSituacao)
				WHERE SIT.idSituacao IN (1, 2, 3, 4)
				GROUP BY SIT.nomeSituacao, SIT.idSituacao
				ORDER BY SIT.idSituacao ASC;";

		//Executa a query e retorna;
		$resultado1 = mysqli_query($conn, $sql1);
?>

<div class="container my-4">
  <h3 class="text-center mb-4">Relatório Quantitativo</h3>
  <form id="frmRelatorioQuantitativo" name="frmRelatorioQuantitativo" method="POST">
    <?php include("includes/validacao.php"); ?>
    <!-- Primeira Tabela -->
    <div class="card mb-4">
      <div class="card-header text-center fw-bold">
        RELATÓRIO QUANTITATIVO DE INSCRITOS NO BANCO DE DADOS
      </div>
      <div class="card-body">
        <p class="text-center fw-semibold">Por Situação</p>
        <p class="text-center">Data: <?php echo date("d/m/Y") ?></p>
        <div class="table-responsive">
          <table class="table table-bordered table-hover align-middle">
            <thead class="table-dark">
              <tr>
                <th class="text-center">Situação</th>
                <th class="text-center">Curso</th>
                <th class="text-center">Inscritos</th>
                <th class="text-center">Ativo</th>
              </tr>
            </thead>
            <tbody>
              <?php
                $cont = 0;
                $cor = "";
                $sum = 0;

                while ($rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {
                  $cor = in_array($rs["idSituacao"], [1, 3]) ? 'table-secondary' : '';
                  $sum += $rs["situacao"];
              ?>
              <tr class="<?php echo $cor; ?>">
                <td class="text-center"><?php echo $rs["nomeSituacao"]; ?></td>
                <td class="text-left"><?php echo $rs["nomeCurso"]; ?></td>
                <td class="text-center"><?php echo $rs["total_situacao"]; ?></td>
                <td class="text-center">
                  <?php if ($rs["status"] == 1) { ?>
                    <img src="images/icon_ativar.png" alt="Ativo" title="Ativo" />
                  <?php } else { ?>
                    <img src="images/icon_desativar.png" alt="Inativo" title="Inativo" />
                  <?php } ?>
                </td>
              </tr>
              <?php $cont++; } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Segunda Tabela -->
    <div class="card">
      <div class="card-header text-center fw-bold">
        RELATÓRIO QUANTITATIVO DE INSCRITOS POR SITUAÇÃO
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered table-hover text-center">
            <thead class="table-dark">
              <tr>
                <th class="text-left">Situação</th>
                <th class="text-right">Inscritos</th>
              </tr>
            </thead>
            <tbody>
              <?php
                $cont1 = 1;
                $cor1 = "";

                while ($rs = mysqli_fetch_array($resultado1, MYSQLI_ASSOC)) {
                  $cor1 = ($cont1 % 2 == 0) ? 'table-secondary' : '';
                  $sum += $rs["situacao"];
              ?>
              <tr class="<?php echo $cor1; ?>">
                <td><?php echo $rs["nomeSituacao"]; ?></td>
                <td class="fw-bold"><?php echo $rs["situacao"]; ?></td>
              </tr>
              <?php $cont1++; } ?>
              <tr class="table-info fw-bold">
                <td>Total geral de inscritos</td>
                <td><?php echo $sum; ?></td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </form>
</div>

<?php
	}else{
		header("Location: frm_login.php");
	}

	require("includes/rodape.php");
?>