<?php
// Caminho do diretório de logs
$logDir = dirname(__DIR__, 2) . DIRECTORY_SEPARATOR . 'logs';// Fica fora do diretório público

// Verifica se o diretório existe, se não existir cria
if (!is_dir($logDir)) {
    if (!mkdir($logDir, 0777, true)) {
        die('Não foi possível criar o diretório de logs: ' . $logDir);
    }
}

// Caminho do arquivo de log
$logFile = $logDir . '/php_errors.txt';

if (!is_writable($logDir)) {
    // Se o diretório não tiver permissão de escrita, lança uma exceção.
    throw new Exception("Erro: O diretório de logs não tem permissão de escrita: " . $logDir);
}

//Conexão com o banco de dados
// $conn = mysqli_connect('127.0.0.1', 'formead', 'ismaelead', 'formead');
$conn = mysqli_connect('127.0.0.1', 'root', 'Raphael2025', 'formead');

mysqli_set_charset($conn, 'utf8');

if (mysqli_connect_errno()) {
    echo 'Erro ao tentar realizar conexao com o banco. Erro retornado: <br/>' . mysqli_connect_error();
    exit();
}

//Função para log personalizado
function registrarLog($mensagem) {
    global $logFile;
    $data = "[" . date('Y-m-d H:i:s') . "] " . $mensagem . PHP_EOL;
    error_log($data, 3, $logFile);
}
?>