<?php

//Anti-SQL-Inject.
function fncAntiInjection($string) {
	return htmlspecialchars(trim($string), ENT_QUOTES, 'UTF-8');
}

// Função simples para escapar caracteres perigosos manualmente
function limpar($valor) {
	return addslashes(strip_tags($valor));
}

// Função para remover acentos e deixar a palavra em caixa alta.
function fncReplace($string) {
 		// Mapeamento de caracteres acentuados para sem acento
    $mapa = [
        'á' => 'a', 'à' => 'a', 'ã' => 'a', 'â' => 'a',
        'é' => 'e', 'ê' => 'e',
        'í' => 'i',
        'ó' => 'o', 'ô' => 'o', 'õ' => 'o',
        'ú' => 'u', 'ü' => 'u',
        'ç' => 'c',
        'Á' => 'A', 'À' => 'A', 'Ã' => 'A', 'Â' => 'A',
        'É' => 'E', 'Ê' => 'E',
        'Í' => 'I',
        'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O',
        'Ú' => 'U', 'Ü' => 'U',
        'Ç' => 'C'
    ];

    // Substitui os caracteres
    $string = strtr($string, $mapa);

    // Converte para maiúsculas
    return strtoupper($string);
}


//Função para gerar n?mero Inscrição.
function fncGeraIncricaoRand($cod) {
    $ano = date("y");     // Ex: 25
    $mes = date("m");     // Ex: 08
    $sequencial = str_pad($cod + 1, 4, "0", STR_PAD_LEFT); // Ex: 0007, 0123, etc.

    return $ano . $mes . $sequencial; // Ex: 25080007
}

//Formatar a data para o padr?o BR dd/mm/yyyy com hora.
function formataData($data) {
	setlocale(LC_ALL, "pt_BR", "ptb");
	$data = date('d/m/Y H:i:s',strtotime($data));
	return $data;
}

//Formatar a data para o padr?o BR dd/mm/yyyy sem hora.
function formataDataSemHora($data) {
	setlocale(LC_ALL, "pt_BR", "ptb");
	$data = date('d/m/Y',strtotime($data));
	return $data;
}

//Formatar a data para o padr?o BR dd/mm/yyyy sem hora.
function formataDataCompleta() {
	setlocale(LC_ALL, "pt_BR", "ptb");
	$dia = date('d');
	$mes = date('m');
	$ano = date('Y');
	$data = $dia . $mes . $ano;
	return array ($dia, $mes ,$ano, $data);
}

//Função para converte para mai?sculas o primeiro caractere de cada palavra. 
function fncConvPrimeiraPalavraMaiuscula($string) {
	$string = mb_convert_case($string, MB_CASE_UPPER, 'iso-8859-1');
	//$string = utf8_decode(ucwords(strtolower($string)));
	return $string;
}


//Função para converte para min?sculas caractere da palavra. 
function fncConvTodasPalavraMinusculas($string) {
	$string = mb_convert_case($string, MB_CASE_LOWER, 'iso-8859-1');
	//$string = trim(strtolower($string));
	return $string;
}

//Função para enviar e-mail de confirmação cadastro de curso.
function fnc_email_inscricao(string $nome, string $email, ?string $inscricao, ?string $numCurso): bool
{
    // Validação do e-mail
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return false;
    }

    // Assunto
    $assunto = "Confirmação de Inscrição EAD";

    // Corpo da mensagem (HTML)
    $mensagem = "
        <html>
        <head>
            <meta charset='UTF-8'>
        </head>
        <body>
            <p>Olá <b>{$nome}</b>,</p>
            <p>
                Sua inscrição no curso <b>{$numCurso}</b> foi realizada com sucesso!<br>
                A data de início das atividades está indicada no cronograma da página EAD da Comunhão Espírita.<br>
                Pelo menos uma semana antes dessa data você receberá a confirmação de sua matrícula, 
                o nome de seu(ua) Tutor(a), seus dados pessoais de acesso ao curso e as instruções para os trabalhos iniciais.
            </p>
            <p>
                Pedimos que faça o primeiro acesso na data indicada.
            </p>
            <p>
                Receba nossa saudação fraterna e votos de muita paz.
            </p>
            <br>
            <p><b>Prof. Alaciel Franklin Almeida</b><br>
            Coordenador do Curso</p>
        </body>
        </html>
    ";

    // Headers
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";
    $headers .= "From: Comunhão Espírita <suporte.ead@comunhaoespirita.org.br>\r\n";
    $headers .= "Reply-To: suporte.ead@comunhaoespirita.org.br\r\n";
    $headers .= "Return-Path: suporte.ead@comunhaoespirita.org.br\r\n";

    // Envio do e-mail
    return mail($email, $assunto, wordwrap($mensagem, 70), $headers);
}

//Função para enviar email de recupera??o de matricula.
function fncEmailRecuperarMatricula(string $email, string $inscricao): bool {
    // Valida o e-mail
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return false;
    }

    // Cabeçalhos para envio em HTML
    $headers = [
        'MIME-Version' => '1.0',
        'Content-type' => 'text/html; charset=UTF-8',
        'From' => 'suporte.ead@comunhaoespirita.org.br'
    ];

    // Converte o array de headers em string
    $headersString = '';
    foreach ($headers as $key => $value) {
        $headersString .= "$key: $value\r\n";
    }

    // Assunto
    $assunto = "Confirmação de Inscrição EAD";

    // Corpo da mensagem em HTML
    $mensagem = "
    <html>
    <head>
        <meta charset='UTF-8'>
        <title>$assunto</title>
    </head>
    <body>
        <p>Sua inscrição foi realizada com sucesso! Como o curso já foi iniciado, manteremos essa inscrição para a próxima turma do curso, cuja data será divulgada no site da Comunhão Espírita.</p>
        <p>Você receberá mensagem por e-mail tão logo sua matrícula for realizada.</p>
        <p>Receba nossa saudação fraterna e votos de muita paz.</p>
        <br>
        <p><strong>Prof. Alaciel Franklin Almeida</strong><br>Coordenador do Curso</p>
    </body>
    </html>";

    // Envia o e-mail e retorna true/false
    return mail($email, $assunto, $mensagem, $headersString);
}

//Função para c?pia o primeira parte do email antes do @.
function fncCriarUsername($string) {
	//Converte todos as letra, 
	$email = fncConvTodasPalavraMinusculas($string);

	//Refazer o _ para .
	$email = str_replace("_", ".", $email);

	//Retira a primeira parte do e-mail
	return strstr($email, '@', true);
}

//Função para c?pia o primeiro nome do usu?rio
function fncCopiarPrimeiraNome($nome) {
	$nome = fncConvPrimeiraPalavraMaiuscula($nome);
	//Retira a primeira parte do e-mail
	return mb_strstr($nome, ' ', true);
}

//Função para c?pia o primeiro nome do usu?rio
function fncCopiarSobreNome($nome) {
	$nome = fncConvPrimeiraPalavraMaiuscula($nome);
	//Retira a primeira parte do e-mail
	return mb_strstr($nome, ' ', false);
}

function fncTelefone($string) {
	$string = str_replace("-", "", $string);
	$string = str_replace(".", "", $string);
	$string = str_replace("/", "", $string);
	$string = str_replace("(", "", $string);
	$string = str_replace(")", "", $string);
	$string = str_replace(" ", "", $string);
	$string = str_replace("+", "", $string);
	
	return $string;
}

function verificarRecaptcha($captcha, $remoteip, $secret, $url) {
	// Verificar se o token foi enviado
	if (empty($captcha)) {
			echo json_encode([
					'status' => false,
					'mensagem' => 'Token reCAPTCHA não recebido.'
			]);
			exit;
	}

	// Preparar dados para verificação
	$data = [
			'secret' => $secret ,
			'response' => $captcha,
			'remoteip' => $remoteip
	];

	$options = [
		'http' => [
			'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
			'method'  => 'POST',
			'content' => http_build_query($data)
		]
	];

	$context = stream_context_create($options);
	$result = file_get_contents( $url, false, $context);
	
	return json_decode($result, true);
}

?>