$(document).ready(function () {
  renderizarDesignDataTablesInscricao();
});

function renderizarDesignDataTablesInscricao() {
  var tabela = $("#tblInscricao").DataTable({
    ajax: {
      url: "acoes/consultar_inscricao.php",
      type: "POST",
      data: function (d) {
        d.nome = $("#filtroNome").val();
        d.curso = $("#filtroCurso").val();
        d.situacao = $("#filtroSituacao").val();
      },
      dataSrc: "data",
    },
    columns: [
      { data: "idCadastro" },
      { data: "inscricao" },
      { data: "nome" },
      { data: "email" },
      { data: "cidade" },
      { data: "uf" },
      { data: "cursos" },
      { data: "datas" },
      { data: "situacoes" },
      {
        data: "idCadastro",
        render: function (data, type, row) {
          return `
            <div class="d-inline-flex gap-1">
              <button class="btn btn-sm btn-primary editar-btn" data-id="${data}">
                <i class="bi bi-pencil-fill"></i>
              </button>
              <button class="btn btn-sm btn-danger excluir-btn" data-id="${data}">
                <i class="bi bi-trash-fill"></i>
              </button>
            </div>
          `;
        },
      },
    ],
    oLanguage: {
      sLengthMenu: "_MENU_",
      sInfo:
        "Mostrando <strong>_START_</strong>-<strong>_END_</strong> de <strong>_TOTAL_</strong> registros",
      sInfoFiltered: "(Filtro de _MAX_ registros)",
      sSearch: "Pesquisar: ",
      sZeroRecords: "Nenhum registro encontrado",
      sProcessing: "Processando",
      sLoadingRecords: "Nenhum registro encontrado",
      sInfoEmpty:
        "Mostrando <strong>_START_</strong>-<strong>_END_</strong> de <strong>_TOTAL_</strong> registros",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    buttons: [], // Define um array vazio, removendo todos os botões
    paging: true, // Habilita a paginação (agora client-side)
    info: true, // Habilita a informação de registros
    lengthChange: true, // Habilita o seletor de "Mostrar X entradas"
    processing: true,
    serverSide: false,
    responsive: true,
    autoWidth: true,
    destroy: true,
    ordering: false,
    stateSave: false,
    displayLength: 10,
    pageLength: 50,
    lengthMenu: [
      [50, 100, 250, 500, -1],
      [50, 100, 250, 500, "Todos"],
    ],
    searching: false,
    scrollX: true,
    scrollY: true,
    dom: "<'row'<'col-sm-12'<'text-center bg-body-light mb-2'B>>><'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>><'row'<'col-sm-12'tr>><'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
    renderer: "bootstrap",
    sType: "brazilian",
    columnDefs: [
      { orderable: false, targets: [9] }, // Ações sem ordenação
      { targets: [0, 1, 4, 5, 7, 8, 9], className: "text-center" }, // idCadastro, inscrição
      { targets: [2, 3, 6], className: "text-start" }, // nome, email, cidade
    ],
  });

  // Eventos dos filtros
  $("#filtroNome, #filtroCurso, #filtroSituacao").on(
    "input change",
    function () {
      tabela.ajax.reload();
    }
  );

  // Clique em Editar
  $("#tblInscricao tbody").on("click", ".editar-btn", function () {
    const idCadastro = $(this).data("id");
    if (idCadastro) {
      inscricaoDetalhas(idCadastro);
    } else {
      console.warn("ID do curso não encontrado");
    }
  });

  // Clique em Excluir
  $("#tblInscricao").on("click", ".excluir-btn", function () {
    const idCadastro = $(this).data("id");
    if (idCadastro) {
      deletarInscricao(idCadastro);
    } else {
      console.warn("ID do curso não encontrado");
    }
  });
}

function formatarTelefone(input) {
  let valor = input.value.replace(/\D/g, ""); // Remove tudo que não é número

  // Máximo de 13 dígitos (ex: +55 11 912345678)
  valor = valor.slice(0, 13);

  // Se começa com 55 (Brasil) ou outro DDI com até 3 dígitos
  if (valor.length <= 3) {
    input.value = `+${valor}`;
  } else if (valor.length <= 6) {
    input.value = `+${valor.slice(0, 2)} (${valor.slice(2)}`;
  } else if (valor.length <= 10) {
    input.value = `+${valor.slice(0, 2)} (${valor.slice(2, 4)}) ${valor.slice(
      4
    )}`;
  } else if (valor.length <= 11) {
    input.value = `+${valor.slice(0, 2)} (${valor.slice(2, 4)}) ${valor.slice(
      4,
      8
    )}-${valor.slice(8)}`;
  } else {
    input.value = `+${valor.slice(0, 2)} (${valor.slice(2, 4)}) ${valor.slice(
      4,
      9
    )}-${valor.slice(9)}`;
  }
}

function fncValidaFormulario(event) {
  event.preventDefault();

  const form = event.target.closest("form");
  const formData = new FormData(form);
  formData.append("Tipo", "N");

  const erroVazio = document.getElementById("erroVazio");
  const erroInvalido = document.getElementById("erroInvalido");

  const siteKey = form.dataset.sitekey;
  const urlDestino = form.dataset.url;

  let valido = true;

  // Limpa mensagens de erro
  function resetarValidacoes() {
    document
      .querySelectorAll(".is-invalid")
      .forEach((el) => el.classList.remove("is-invalid"));
    document
      .querySelectorAll(".invalid-feedback")
      .forEach((el) => el.classList.add("d-none"));
  }

  // Valida campo obrigatório
  function validarCampoObrigatorio(id) {
    const campo = document.getElementById(id);
    if (!campo || campo.value.trim() === "") {
      campo.classList.add("is-invalid");
      const feedback = campo.nextElementSibling;
      if (feedback && feedback.classList.contains("invalid-feedback")) {
        feedback.classList.remove("d-none");
      }
      valido = false;
    }
  }

  // Valida grupo de radio
  function validarRadio(name, erroId, descricao) {
    if (!document.querySelector(`input[name="${name}"]:checked`)) {
      document.getElementById(erroId)?.classList.remove("d-none");
      notificacao("Selecione " + descricao, "error");
      valido = false;
    }
  }

  // Valida igualdade de dois campos
  function validarConfirmacaoEmail(id1, id2) {
    const val1 = document.getElementById(id1)?.value.trim();
    const val2 = document.getElementById(id2)?.value.trim();

    fncValidaMail(id1, erroVazio, erroInvalido);

    if (val1 !== val2) {
      document.getElementById(id2)?.classList.add("is-invalid");
      notificacao("E-mails diferentes!", "error");
      valido = false;
    }
  }

  // Início da validação
  resetarValidacoes();

  const camposObrigatorios = [
    "Nome",
    "Email",
    "ConfirmarEmail",
    "TelResidencial",
    "TelCelular",
    "Pais",
    "Endereco",
    "Bairro",
    "Cidade",
    "UF",
    "cep",
  ];

  camposObrigatorios.forEach(validarCampoObrigatorio);

  validarRadio("Nacionalidade", "erroNacionalidade", "nacionalidade.");
  validarRadio("Curso", "erroCurso", " o curso.");
  validarRadio(
    "DispoeSemana",
    "erroDispoeSemana",
    "a disponibilidade na semana."
  );
  validarRadio(
    "ProblemaForcaMaior",
    "erroProblemaForcaMaior",
    "opção de comprometimento."
  );

  // Seleciona todos os checkboxes com name="Escolaridade"
  const escolaridadeCheckboxes = document.querySelectorAll(
    'input[name="Escolaridade"]'
  );

  // Verifica se pelo menos um está marcado
  const algumMarcado = Array.from(escolaridadeCheckboxes).some(
    (checkbox) => checkbox.checked
  );

  if (!algumMarcado) {
    // Adiciona classe de erro a todos os checkboxes
    escolaridadeCheckboxes.forEach((checkbox) =>
      checkbox.classList.add("is-invalid")
    );

    // Exibe notificação
    notificacao("Selecione a escolaridade", "error");

    valido = false;
  } else {
    // Remove erro se algum estiver marcado
    escolaridadeCheckboxes.forEach((checkbox) =>
      checkbox.classList.remove("is-invalid")
    );
  }

  validarConfirmacaoEmail("Email", "ConfirmarEmail");

  // Se tiver erro, não envia
  if (!valido) return false;

  grecaptcha.ready(function () {
    grecaptcha.execute(siteKey, { action: "submit" }).then(function (token) {
      formData.append("g-recaptcha-response", token);
      // Envia os dados via AJAX
      $.ajax({
        url: urlDestino,
        type: "POST",
        dataType: "JSON",
        data: formData,
        contentType: false,
        processData: false,
        cache: false,
        success: function (response) {
          if (response.status) {
            notificacao(response.mensagem, "success");
            form.reset();
          } else {
            notificacao(response.mensagem, "error");
          }
        },
        error: function (error) {
          notificacao("Erro de comunicação com o servidor.", "error");
        },
      });
    });
  });
}

function fncValidaFormularioExistente(event) {
  event.preventDefault();

  const form = event.target.closest("form");
  const formData = new FormData(form);
  formData.append("Tipo", "E");

  const erroVazio = document.getElementById("erroVazio");
  const erroInvalido = document.getElementById("erroInvalido");

  const siteKey = form.dataset.sitekey;
  const urlDestino = form.dataset.url;

  let valido = true;

  // Limpa mensagens de erro
  function resetarValidacoes() {
    document
      .querySelectorAll(".is-invalid")
      .forEach((el) => el.classList.remove("is-invalid"));
    document
      .querySelectorAll(".invalid-feedback")
      .forEach((el) => el.classList.add("d-none"));
  }

  // Valida campo obrigatório
  function validarCampoObrigatorio(id) {
    const campo = document.getElementById(id);
    if (!campo || campo.value.trim() === "") {
      campo.classList.add("is-invalid");
      const feedback = campo.nextElementSibling;
      if (feedback && feedback.classList.contains("invalid-feedback")) {
        feedback.classList.remove("d-none");
      }
      valido = false;
    }
  }

  // Valida grupo de radio
  function validarRadio(name, erroId, descricao) {
    if (!document.querySelector(`input[name="${name}"]:checked`)) {
      document.getElementById(erroId)?.classList.remove("d-none");
      notificacao("Selecione " + descricao, "error");
      valido = false;
    }
  }

  // Valida igualdade de dois campos
  function validarConfirmacaoEmail(id1, id2) {
    const val1 = document.getElementById(id1)?.value.trim();
    const val2 = document.getElementById(id2)?.value.trim();

    fncValidaMail(id1, erroVazio, erroInvalido);

    if (val1 !== val2) {
      document.getElementById(id2)?.classList.add("is-invalid");
      notificacao("E-mails diferentes!", "error");
      valido = false;
    }
  }

  // Início da validação
  resetarValidacoes();

  const camposObrigatorios = [
    "Email",
    "ConfirmarEmail",
    "TelResidencial",
    "TelCelular",
    "Pais",
    "Endereco",
    "Bairro",
    "Cidade",
    "UF",
    "cep",
  ];

  camposObrigatorios.forEach(validarCampoObrigatorio);

  validarRadio("Nacionalidade", "erroNacionalidade", "nacionalidade.");
  validarRadio("Curso", "erroCurso", " o curso.");
  validarRadio(
    "DispoeSemana",
    "erroDispoeSemana",
    "a disponibilidade na semana."
  );
  validarRadio(
    "ProblemaForcaMaior",
    "erroProblemaForcaMaior",
    "opção de comprometimento."
  );

  // Seleciona todos os checkboxes com name="Escolaridade"
  const escolaridadeCheckboxes = document.querySelectorAll(
    'input[name="Escolaridade"]'
  );

  // Verifica se pelo menos um está marcado
  const algumMarcado = Array.from(escolaridadeCheckboxes).some(
    (checkbox) => checkbox.checked
  );

  if (!algumMarcado) {
    // Adiciona classe de erro a todos os checkboxes
    escolaridadeCheckboxes.forEach((checkbox) =>
      checkbox.classList.add("is-invalid")
    );

    // Exibe notificação
    notificacao("Selecione a escolaridade", "error");

    valido = false;
  } else {
    // Remove erro se algum estiver marcado
    escolaridadeCheckboxes.forEach((checkbox) =>
      checkbox.classList.remove("is-invalid")
    );
  }

  validarConfirmacaoEmail("Email", "ConfirmarEmail");

  // Se tiver erro, não envia
  if (!valido) return false;

  grecaptcha.ready(function () {
    grecaptcha.execute(siteKey, { action: "submit" }).then(function (token) {
      formData.append("g-recaptcha-response", token);
      // Envia os dados via AJAX
      $.ajax({
        url: urlDestino,
        type: "POST",
        dataType: "JSON",
        data: formData,
        contentType: false,
        processData: false,
        cache: false,
        success: function (response) {
          if (response.status) {
            notificacao(response.mensagem, "success");
            window.location.href =
              "frm_inscricao_existente.php?tipo=R&id=" + response.idCadastro;
          } else {
            notificacao(response.mensagem, "error");
          }
        },
        error: function (error) {
          console.log(error);
          notificacao("Erro de comunicação com o servidor.", "error");
        },
      });
    });
  });
}

function fncValidarInscricaoExistente(event) {
  event.preventDefault();

  const form = event.target.closest("form");
  const siteKey = form.dataset.sitekey;
  const urlDestino = form.dataset.url;

  let valido = true;

  // validação de campos obrigatórios
  function validarCampoObrigatorio(id) {
    const campo = document.getElementById(id);
    if (!campo || campo.value.trim() === "") {
      campo.classList.add("is-invalid");
      valido = false;
    } else {
      campo.classList.remove("is-invalid");
    }
  }

  // lista de campos obrigatórios
  const camposObrigatorios = ["NomeExistente", "EmailExistente"];
  camposObrigatorios.forEach(validarCampoObrigatorio);

  if (!valido) return false;

  // cria FormData
  const formData = new FormData(form);
  formData.append("Tipo", "E");

  // executa reCAPTCHA v3
  grecaptcha.ready(function () {
    grecaptcha.execute(siteKey, { action: "submit" }).then(function (token) {
      formData.append("g-recaptcha-response", token);
      // Envia via AJAX
      $.ajax({
        url: urlDestino,
        type: "POST",
        dataType: "json",
        data: formData,
        contentType: false,
        processData: false,
        cache: false,
        success: function (response) {
          if (response.status) {
            window.location.href =
              "frm_inscricao_existente.php?tipo=R&id=" + response.idCadastro;
          } else {
            notificacao(response.mensagem, "error");
          }
        },
        error: function (error) {
          notificacao("Erro de comunicação com o servidor.", "error");
        },
      });
    });
  });

  return false; // bloqueia submit padrão
}

function fncValidaFormularioDetalhar(event) {
  event.preventDefault();

  const form = event.target.closest("form");
  const formData = new FormData(form);
  formData.append("Tipo", "D"); // Detalhe do aluno

  const erroVazio = document.getElementById("erroVazio");
  const erroInvalido = document.getElementById("erroInvalido");

  const siteKey = form.dataset.sitekey;
  const urlDestino = form.dataset.url;

  let valido = true;

  // Limpa mensagens de erro
  function resetarValidacoes() {
    document
      .querySelectorAll(".is-invalid")
      .forEach((el) => el.classList.remove("is-invalid"));
    document
      .querySelectorAll(".invalid-feedback")
      .forEach((el) => el.classList.add("d-none"));
  }

  // Valida campo obrigatório
  function validarCampoObrigatorio(id) {
    const campo = document.getElementById(id);
    if (!campo || campo.value.trim() === "") {
      campo.classList.add("is-invalid");
      const feedback = campo.nextElementSibling;
      if (feedback && feedback.classList.contains("invalid-feedback")) {
        feedback.classList.remove("d-none");
      }
      valido = false;
    }
  }

  // Valida grupo de radio
  function validarRadio(name, erroId, descricao) {
    if (!document.querySelector(`input[name="${name}"]:checked`)) {
      document.getElementById(erroId)?.classList.remove("d-none");
      notificacao("Selecione " + descricao, "error");
      valido = false;
    }
  }

  // Valida igualdade de dois campos
  function validarConfirmacaoEmail(id1, id2) {
    const val1 = document.getElementById(id1)?.value.trim();
    const val2 = document.getElementById(id2)?.value.trim();

    fncValidaMail(id1, erroVazio, erroInvalido);

    if (val1 !== val2) {
      document.getElementById(id2)?.classList.add("is-invalid");
      notificacao("E-mails diferentes!", "error");
      valido = false;
    }
  }

  // Início da validação
  resetarValidacoes();

  const camposObrigatorios = [
    "Nome",
    "Email",
    "ConfirmarEmail",
    "TelResidencial",
    "TelCelular",
    "Pais",
    "Endereco",
    "Bairro",
    "Cidade",
    "UF",
    "cep",
  ];

  camposObrigatorios.forEach(validarCampoObrigatorio);

  validarRadio("Nacionalidade", "erroNacionalidade", "nacionalidade.");
  validarRadio(
    "DispoeSemana",
    "erroDispoeSemana",
    "a disponibilidade na semana."
  );
  validarRadio(
    "ProblemaForcaMaior",
    "erroProblemaForcaMaior",
    "opção de comprometimento."
  );

  // Seleciona todos os checkboxes com name="Escolaridade"
  const escolaridadeCheckboxes = document.querySelectorAll(
    'input[name="Escolaridade"]'
  );

  // Verifica se pelo menos um está marcado
  const algumMarcado = Array.from(escolaridadeCheckboxes).some(
    (checkbox) => checkbox.checked
  );

  if (!algumMarcado) {
    // Adiciona classe de erro a todos os checkboxes
    escolaridadeCheckboxes.forEach((checkbox) =>
      checkbox.classList.add("is-invalid")
    );

    // Exibe notificação
    notificacao("Selecione a escolaridade", "error");

    valido = false;
  } else {
    // Remove erro se algum estiver marcado
    escolaridadeCheckboxes.forEach((checkbox) =>
      checkbox.classList.remove("is-invalid")
    );
  }

  validarConfirmacaoEmail("Email", "ConfirmarEmail");

  // Se tiver erro, não envia
  if (!valido) return false;

  grecaptcha.ready(function () {
    grecaptcha.execute(siteKey, { action: "submit" }).then(function (token) {
      formData.append("g-recaptcha-response", token);
      // Envia os dados via AJAX
      $.ajax({
        url: urlDestino,
        type: "POST",
        dataType: "JSON",
        data: formData,
        contentType: false,
        processData: false,
        cache: false,
        success: function (response) {
          if (response.status) {
            notificacao(response.mensagem, "success");
            form.reset();
          } else {
            notificacao(response.mensagem, "error");
          }
        },
        error: function (error) {
          notificacao("Erro de comunicação com o servidor.", "error");
        },
      });
    });
  });
}

document.addEventListener("DOMContentLoaded", function () {
  const emailInput = document.getElementById("Email");
  const erroVazio = document.getElementById("erroVazio");
  const erroInvalido = document.getElementById("erroInvalido");

  if (emailInput) {
    // Remove mensagens ao digitar
    emailInput.addEventListener("input", function () {
      emailInput.classList.remove("is-invalid", "is-valid");
      erroVazio.classList.add("d-none");
      erroInvalido.classList.add("d-none");
    });
  }

  const camposObrigatorios = [
    "Nome",
    "Email",
    "ConfirmarEmail",
    "TelResidencial",
    "TelCelular",
    "Pais",
    "Endereco",
    "Bairro",
    "Cidade",
    "UF",
    "cep",
  ];

  camposObrigatorios.forEach((id) => {
    const campo = document.getElementById(id);
    if (campo) {
      campo.addEventListener("input", function () {
        campo.classList.remove("is-invalid");
        const feedback = campo.nextElementSibling;
        if (feedback && feedback.classList.contains("invalid-feedback")) {
          feedback.classList.add("d-none");
        }
      });
    }
  });
});
