<?php
session_start();

if (!isset($_SESSION['__idUsu'])) {
    header("Location: ../frm_login.php");
    exit;
}

header('Content-Type: application/json; charset=utf-8');

require("../includes/conexao.php");
require("../includes/funcoes.php");

$ids = isset($_POST['selecionados']) ? (array) $_POST['selecionados'] : [];
$novo_status = isset($_POST['novoStatus']) ? trim($_POST['novoStatus']) : null;

if (empty($ids) || empty($novo_status)) {
	http_response_code(400);
	echo json_encode(["status" => false, "mensagem" => "Seleção ou status inválidos."]);
	exit;
}

if (!is_array($ids)) {
  $ids = [$ids];
}

$statusPermitidos = ["Matriculado", "Cursando", "Concluído", "Abandono"];
if (!in_array($novo_status, $statusPermitidos, true)) {
	http_response_code(400);
	echo json_encode(["status" => false, "mensagem" => "Status inválido."]);
	exit;
}

$conn->begin_transaction();

try {
	// Busca idSituacao usando bind_result
	$stmt = $conn->prepare("SELECT idSituacao FROM tbl_situacao_aluno WHERE nomeSituacao = ? LIMIT 1");
	$stmt->bind_param("s", $novo_status);
	$stmt->execute();
	$stmt->bind_result($idSituacao);

	if (!$stmt->fetch()) {
			echo json_encode(["status" => false, "mensagem" => "Status não encontrado no banco."]);
			$stmt->close();
			exit;
	}
	$stmt->close();

	// Garante que todos os IDs são inteiros
	$ids = array_map('intval', $ids);
	$ids_str = implode(',', $ids);

	$sqlBackup = "
			INSERT INTO tbl_curso_cadastro_backup (idCadastro, dados_antigos, data_backup)
			SELECT
					idCadastro,
					CONCAT(
							'{\"idRelCursoCadastro\": \"', idRelCursoCadastro, '\",',
							'\"idCurso\": \"', idCurso, '\",',
							'\"idSituacao\": \"', idSituacao, '\",',
							'\"dtCadastroCurso\": \"', dtCadastroCurso, '\"}'
					),
					NOW()
			FROM tbl_curso_cadastro
			WHERE idRelCursoCadastro IN ($ids_str)
	";

	if (!mysqli_query($conn, $sqlBackup)) {
			echo json_encode(["status" => false, "mensagem" => "Erro ao criar backup: " . mysqli_error($conn)]);
			exit;
	}

	// Atualiza todos de uma vez
	$sqlUpdate = "
			UPDATE tbl_curso_cadastro 
			SET idSituacao = $idSituacao
			WHERE idRelCursoCadastro IN ($ids_str)
	";

	if (!mysqli_query($conn, $sqlUpdate)) {
			echo json_encode(["status" => false, "mensagem" => "Erro ao atualizar status: " . mysqli_error($conn)]);
			exit;
	}

	// Se tudo deu certo, comita a transação
	$conn->commit();

	// Registrar log de sucesso
	if (function_exists('registrarLog')) {
		registrarLog("Status atualizado com sucesso para IDs: " . implode(', ', $ids));
	}

	// Se tudo deu certo, comita a transação
	$conn->commit();

	echo json_encode(["status" => true, "mensagem" => "Status atualizado com sucesso."]);

} catch (Exception $e) {

	$conn->rollback();

	// Registrar log de erro da exceção
	if (function_exists('registrarLog')) {
		registrarLog("Erro ao atualizar status: " . $e->getMessage());
	}

	http_response_code(500);
	echo json_encode(["status" => false, "mensagem" => "Erro ao atualizar status."]);

	if (isset($stmt) && $stmt) $stmt->close();
	if (isset($stmtBackup) && $stmtBackup) $stmtBackup->close();
	if (isset($stmtUpdate) && $stmtUpdate) $stmtUpdate->close();
}

$conn->close();
?>