<?php
session_start();

header('Content-Type: application/json; charset=utf-8');

require_once('../includes/conexao.php');
require('../includes/funcoes.php');
require('../includes/configGoogle.php');
require('../includes/configMoodle.php');
require('../acoes/moodle/moodle_api.php');

$tipo = isset($_REQUEST["Tipo"]) ? $_REQUEST["Tipo"] : "";
$captcha = $_POST['g-recaptcha-response'] ?? '';
$remoteip = $_SERVER['REMOTE_ADDR'] ?? null;

$secretMoodle = ConfigMoodle::MOODLE_TOKEN_KEY;
$urlMoodle = ConfigMoodle::MOODLE_SITE_URL;

// --- Captura chaves ---
$secretGoogle = ConfigGoogle::GOOGLE_RECAPTCHA_SECRET_KEY;
$urlGoogle = ConfigGoogle::GOOGLE_RECAPTCHA_VERIFY_URL;

if (ConfigGoogle::MODO_DEV) {
  $recaptchaResponse = ['success' => true, 'score' => 0.9];
} else {
  $recaptchaResponse = verificarRecaptcha($captcha, $remoteip, $secretGoogle, $urlGoogle);
}

//$recaptchaResponse = verificarRecaptcha($captcha, $remoteip, $secretGoogle, $urlGoogle);

if ($recaptchaResponse['success'] === false) {
  echo json_encode([
    "status" => false,
    "mensagem" => "Erro ao conectar com a API do Google."
  ]);
  exit;
}

if ($recaptchaResponse['score'] < ConfigGoogle::GOOGLE_MIN_SCORE) {
  echo json_encode([
    "status" => false,
    "mensagem" => 'Pontuação reCAPTCHA muito baixa. Possível bot.'
  ]);
  exit;
}

if ($recaptchaResponse['success']) {
  if ($tipo == 'N') {
    //Anti Injection
    $nome = fncAntiInjection($_POST["Nome"]);
    $email = fncAntiInjection($_POST["Email"]);

    //Verifica o nome antes de incluir na tabela de tbl_cadastro.
    $stmt = $conn->prepare("SELECT idCadastro, inscricao FROM tbl_cadastro WHERE UPPER(email) = UPPER(?)");
    $stmt->bind_param("s", $email); // "s" para string
    $stmt->execute();
    // Declare as variáveis que vão receber os dados
    $stmt->bind_result($idCad, $numInscricao);
    $stmt->fetch();

    //Verifica se a variável &idCad não existe, se não existir cadastra.
    if ((is_null($idCad)) || ($idCad == 0)) {

      $conn->begin_transaction();

      try {

        //Seleciona o último id inserido da tabela cadastro para ser conctenado o número de Inscrição gerado pela Função fncGeraIncricaoRand.
        $sql = 'SELECT idCadastro FROM tbl_cadastro ORDER BY idCadastro DESC LIMIT 1';
        $resultado = mysqli_query($conn, $sql);

        $rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC);
        $cod = $rs["idCadastro"];

        //------------------------------------------------------------------------------

        //Variáveis
        $idCurso = $_POST["Curso"];
        $inscricao = fncGeraIncricaoRand($cod);
        $nome = strtoupper(trim($_POST["Nome"] ?? ''));
        $dataDeNacimento = fncAntiInjection($_POST["DatadeNacimento"]);
        $telResidencial = trim($_POST["TelResidencial"] ?? '');
        $telTrabalho = trim($_POST["TelTrabalho"] ?? '');
        $telCelular = trim($_POST["TelCelular"] ?? '');
        $email = fncConvTodasPalavraMinusculas($_POST["Email"]);
        //Função para criar username a partir no email
        $username = fncCriarUsername($email);
        $confirmarEmail = fncConvTodasPalavraMinusculas($_POST["ConfirmarEmail"]);
        $pais = fncConvPrimeiraPalavraMaiuscula($_POST["Pais"] ?? '');
        $endereco = fncAntiInjection($_POST["Endereco"] ?? '');
        $complemento = fncAntiInjection($_POST["Complemento"] ?? '');
        $bairro = fncConvPrimeiraPalavraMaiuscula(fncAntiInjection($_POST["Bairro"] ?? ''));
        $uf = fncAntiInjection($_POST["UF"]);
        $uf = fncReplace(fncAntiInjection($_POST["UF"] ?? ''));
        $cidade = fncAntiInjection(fncConvPrimeiraPalavraMaiuscula($_POST["Cidade"] ?? ''));
        $cep = fncAntiInjection($_POST["cep"]);
        $quantoTempoNaDoutrina = fncAntiInjection($_POST["QuantoTemponaDoutrina"] ?? '');
        $atividadeProfissiona = fncAntiInjection($_POST["AtividadeProfissiona"] ?? '');
        $dispoeSemana = (int) ($_POST["DispoeSemana"] ?? 0);
        $problemaForcaMaior = (int) ($_POST["ProblemaForcaMaior"] ?? 0);
        $escolaridade = fncAntiInjection($_POST["Escolaridade"] ?? '');
        $nacionalidade = $_POST["Nacionalidade"];
        $identificacao = fncAntiInjection($_POST["Identificacao"] ?? '');
        $dateCad = date('Y/m/d, H:i:s') ?? $_POST["dateCad"];

        // Validações básicas
        if (empty($telCelular)) {
          echo json_encode([
            "status" => false,
            "mensagem" => "Telefone celular é obrigatório."
          ]);
          exit;
        }

        //------------------------------------------------------------------------------
        //Select para recuperar o nome do curso
        $stmt = $conn->prepare("SELECT idCurso, nomeCurso FROM tbl_curso WHERE (status = 1) AND (idCurso = ?)");
        $stmt->bind_param("i", $idCurso);
        $stmt->execute();
        // Declare as variáveis que vão receber os dados
        $stmt->bind_result($idCurso, $nomeCurso);
        $stmt->fetch();

        $stmt->free_result(); // <== Limpa o resultado antes de nova execução
        $stmt->close();
        //------------------------------------------------------------------------------

        //Verifica se a variável $nome existe.
        if (isset($nome)) {

          //Query de inserção.
          $sql = "INSERT INTO tbl_cadastro
                      (inscricao,
                      nome,
                      username,
                      dataNacimento,
                      telResidencial,
                      telTrabalho,
                      telCelular,
                      email,
                      confirmarEmail,
                      pais,
                      endereco,
                      complemento,
                      bairro,
                      cidade,
                      uf,
                      cep,
                      qtTempDoutrina,
                      atividadeProf,
                      dispoeSemana,
                      problemaForcaMaior,
                      escolaridade,
                      identificacao,
                      nacionalidade)
                  VALUES
                      ('" . $inscricao . "',
                      '" . $nome . "',
                      '" . $username . "',
                      '" . $dataDeNacimento . "',
                      '" . $telResidencial . "',
                      '" . $telTrabalho . "',
                      '" . $telCelular . "',
                      '" . $email . "',
                      '" . $confirmarEmail . "',
                      '" . $pais . "',
                      '" . $endereco . "',
                      '" . $complemento . "',
                      '" . $bairro . "',
                      '" . $cidade . "',
                      '" . $uf . "',
                      '" . $cep . "',
                      '" . $quantoTempoNaDoutrina . "',
                      '" . $atividadeProfissiona . "',
                      " . $dispoeSemana . ",
                      " . $problemaForcaMaior . ",
                      '" . $escolaridade . "',
                      '" . $identificacao . "',
                      " . $nacionalidade . ")";

          $resultado = mysqli_query($conn, $sql);

          //Último id inserido.
          $idRetornoDoCadastro = mysqli_insert_id($conn);

          echo  $dtCadastroCurso = date('Y/m/d, H:i:s');
          //Insere o id da tabela cadastro e curso para o relacionamento.
          $sql1 = "INSERT INTO tbl_curso_cadastro (idCadastro, idCurso, dtCadastroCurso, idSituacao)
                  VALUES ($idRetornoDoCadastro, $idCurso, '$dtCadastroCurso', 1)";
          echo   $sql1;
          //Envia a query para o banco de dados.
          $resultado1 = mysqli_query($conn, $sql1);

          exit();
          //Verifica a matricula
          if (!$resultado) {
            echo json_encode(['status' => false, 'mensagem' => 'Erro ao inserir dados!']);
          } else {


            // // // ID do curso no Moodle (pego na URL &id=XX)
            // $courseId = 23;

            // //           try {

            // // Seleciona o aluno recém-cadastrado na tabela
            $sqlAluno = "SELECT nome, email, username, cidade, pais
                          FROM tbl_cadastro
                          WHERE idCadastro = ?";

            $stmtAluno = $conn->prepare($sqlAluno);
            $stmtAluno->bind_param("i", $idRetornoDoCadastro);
            $stmtAluno->execute();
            $resultAluno = $stmtAluno->get_result();

            if ($rowAluno = $resultAluno->fetch_assoc()) {

              // Monta o JSON com dados reais vindos do banco
              $aluno = [
                'username'     => fncRemoverAcentos($rowAluno['username']),
                'password'     => 'Senha@2025', // pode gerar dinâmica se quiser
                'firstname'    => explode(' ', $rowAluno['nome'])[0], // primeiro nome
                'lastname'     => implode(' ', array_slice(explode(' ', $rowAluno['nome']), 1)),
                'email'        => $rowAluno['email'],
                'city'         => fncRemoverAcentos($rowAluno['cidade']),
                'country'      => $rowAluno['pais'] ?: 'BR',
                'lang'         => 'pt_br',
                'description'  => 'Aluno do curso ' . $nomeCurso,
                'auth'         => 'manual'
              ];
            } else {
              echo json_encode([
                "status" => false,
                "mensagem" => "Erro: não foi possível localizar o aluno na tabela tbl_cadastro."
              ]);
              exit;
            }

            $returnoMoodle = formataDadosMoodle($aluno, $token, $moodleUrl, $courseId);
            echo $returnoMoodle;
            //   // echo "Matrícula realizada com sucesso no curso ID $courseId\n";
            // } catch (Exception $e) {
            //   echo "Erro: " . $e->getMessage();
            // }

            //Enviar e-mail de agradecimento
            //fncEmailInscricao($nome, $email, $inscricao, $nomeCurso);

            // Se tudo deu certo, comita a transação
            //$conn->commit();

            exit;

            echo json_encode([
              'status' => true,
              'mensagem' => 'Sua inscrição foi realizada com sucesso! Você receberá uma mensagem via e-mail com os dados para acesso ao curso. Saudações fraternas.\nProf. Alaciel Franklin Almeida - Coordenador do Curso'
            ]);
          }
        }
      } catch (Exception $e) {

        $conn->rollback();

        // Registrar log de erro da exceção
        if (function_exists('registrarLog')) {
          registrarLog("Erro ao atualizar status: " . $e->getMessage());
        }

        http_response_code(500);
        echo json_encode([
          "status" => false,
          "mensagem" => "Erro na inscrição."
        ]);

        if (isset($stmt) && $stmt) $stmt->close();
      }
    } else {
      echo json_encode([
        'status' => false,
        'mensagem' => 'Você já possui uma inscrição! O seu número é ' . $numInscricao . '.'
      ]);
    }
  } else {
    //Recuperar Inscrição
    $nome = fncAntiInjection($_POST["NomeExistente"]);
    $nome = fncReplace($nome);
    $email = fncConvTodasPalavraMinusculas($_POST["EmailExistente"]);

    $sql = "SELECT idCadastro, inscricao, nome, email
            FROM tbl_cadastro
            WHERE (nome = '" . $nome . "') or (email = '" . $email . "');";

    $resultado = mysqli_query($conn, $sql);
    $rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC);

    if ($rs) {

      $idCadastro_ = $rs["idCadastro"];
      $matricula_ = $rs["inscricao"];
      $nome_ = $rs["nome"];
      $email_ = $rs["email"];

      // Busca todos os cursos do aluno
      $sqlCursos = "SELECT idCurso, idSituacao
                    FROM tbl_curso_cadastro
                    WHERE idCadastro = " . $idCadastro_;
      $resCursos = mysqli_query($conn, $sqlCursos);

      $totalMatriculado = 0;
      $possuiReativacao = false;

      while ($row = mysqli_fetch_assoc($resCursos)) {
        if ((int)$row["idSituacao"] === 1) {
          $totalMatriculado++;
        }
        if (in_array((int)$row["idSituacao"], [3, 4])) {
          $possuiReativacao = true;
        }
      }

      // Agora decide a mensagem
      if ($totalMatriculado >= 2) {
        echo json_encode([
          'status' => false,
          'mensagem' => 'O aluno já possui 2 cursos matriculados. Não é possível adicionar outro.'
        ]);
      } elseif ($possuiReativacao) {
        if (isset($matricula_) and isset($email_)) {
          $_SESSION['__inscricao'] = $matricula_;

          fncEmailRecuperarMatricula($email_, $matricula_);

          echo json_encode(['status' => true, 'idCadastro' => $idCadastro_]);
        } else {
          echo json_encode(['status' => false, 'mensagem' => 'Nome ou e-mail inexistente(s)']);
        }
      } elseif ($totalMatriculado < 2) {
        //Verifica a existéncia da valor nas variáveis.
        if (isset($matricula_) and isset($email_)) {
          $_SESSION['__inscricao'] = $matricula_;

          fncEmailRecuperarMatricula($email_, $matricula_);

          echo json_encode(['status' => true, 'idCadastro' => $idCadastro_]);
        } else {
          echo json_encode(['status' => false, 'mensagem' => 'Nome ou e-mail inexistente(s)']);
        }
      } else {
        echo json_encode([
          'status' => false,
          'mensagem' => 'Não foi possível determinar a situação do aluno.'
        ]);
      }
    } else {
      echo json_encode(['status' => false, 'mensagem' => 'Nome ou e-mail inexistente(s)']);
    }
  }
} else {
  $errorCodes = $response['error-codes'] ?? ['unknown-error'];
  echo json_encode([
    "status" => false,
    "mensagem" => "Falha na verificação reCAPTCHA.",
    "erros" => $errorCodes
  ]);
}

//Fecha a conexão com o banco
mysqli_close($conn);
