<?php
session_start();

if (!isset($_SESSION['__idUsu'])) {
	header("Location: logout.php");
	exit;
}

header('Content-Type: application/json; charset=utf-8');

require_once('../includes/conexao.php');
require('../includes/funcoes.php');
require('../includes/configGoogle.php');

//Tipo de validação cadastro ou consulta.
$tipo = $_POST["Tipo"] ?? '';
$idCadastro = (int) ($_POST["idCadastro"] ?? 0);
$dateCad = date('Y-m-d H:i:s');
$captcha = $_POST['g-recaptcha-response'] ?? '';
$remoteip = $_SERVER['REMOTE_ADDR'] ?? null;

// --- Captura chaves ---
$secret = ConfigGoogle::GOOGLE_RECAPTCHA_SECRET_KEY;
$url = ConfigGoogle::GOOGLE_RECAPTCHA_VERIFY_URL;

$recaptchaResponse = verificarRecaptcha($captcha, $remoteip, $secret, $url);

if ($recaptchaResponse['success'] === false) {
	echo json_encode([
		"status" => false,
		"mensagem" => "Erro ao conectar com a API do Google."
	]);
	exit;
}

if ($recaptchaResponse['score'] < ConfigGoogle::GOOGLE_MIN_SCORE) {
	echo json_encode([
		"status" => false,
		"mensagem" => 'Pontuação reCAPTCHA muito baixa. Possível bot.'
	]);
	exit;
}

// ------------------------------------------------------------------
// UPDATE usando OO com $stmt->execute()
// ------------------------------------------------------------------
if ($tipo === "D") {

	$nome = strtoupper(trim($_POST["Nome"] ?? ''));
	$telResidencial = trim($_POST["TelResidencial"] ?? '');
	$telTrabalho = trim($_POST["TelTrabalho"] ?? '');
	$telCelular = trim($_POST["TelCelular"] ?? '');
	$pais = fncConvPrimeiraPalavraMaiuscula($_POST["Pais"] ?? '');
	$endereco = fncAntiInjection($_POST["Endereco"] ?? '');
	$complemento = fncAntiInjection($_POST["Complemento"] ?? '');
	$bairro = fncConvPrimeiraPalavraMaiuscula(fncAntiInjection($_POST["Bairro"] ?? ''));
	$uf = fncReplace(fncAntiInjection($_POST["UF"] ?? ''));
	$cidade = fncConvPrimeiraPalavraMaiuscula(fncAntiInjection($_POST["Cidade"] ?? ''));
	$cep = fncAntiInjection($_POST["cep"] ?? '');
	$quantoTempoNaDoutrina = fncAntiInjection($_POST["QuantoTemponaDoutrina"] ?? '');
	$atividadeProfissiona  = fncAntiInjection($_POST["AtividadeProfissiona"] ?? '');
	$dispoeSemana = (int) ($_POST["DispoeSemana"] ?? 0);
	$problemaForcaMaior = (int) ($_POST["ProblemaForcaMaior"] ?? 0);
	$escolaridade = fncAntiInjection($_POST["Escolaridade"] ?? '');
	$identificacao = fncAntiInjection($_POST["Identificacao"] ?? '');
	$nacionalidade = (int) ($_POST["Nacionalidade"] ?? 0);

	// Validações básicas
	if (empty($telCelular)) {
		echo json_encode([
			"status" => false,
			"mensagem" => "Telefone celular é obrigatório."
		]);
		exit;
	}

	// Inicia transação para garantir consistência
	$conn->begin_transaction();

	try {

		$stmt = $conn->prepare("
				UPDATE tbl_cadastro SET
					nome = ?,
					telResidencial = ?,
					telTrabalho = ?,
					telCelular = ?,
					pais = ?,
					endereco = ?,
					complemento = ?,
					bairro = ?,
					cidade = ?,
					uf = ?,
					cep = ?,
					qtTempDoutrina = ?,
					atividadeProf = ?,
					dispoeSemana = ?,
					problemaForcaMaior = ?,
					escolaridade = ?,
					identificacao = ?,
					nacionalidade = ?
				WHERE idCadastro = ?
			");

		$stmt->bind_param(
			"sssssssssssssiissii",
			$nome,
			$telResidencial,
			$telTrabalho,
			$telCelular,
			$pais,
			$endereco,
			$complemento,
			$bairro,
			$cidade,
			$uf,
			$cep,
			$quantoTempoNaDoutrina,
			$atividadeProfissiona,
			$dispoeSemana,
			$problemaForcaMaior,
			$escolaridade,
			$identificacao,
			$nacionalidade,
			$idCadastro
		);

		if (!$stmt->execute()) {
			echo json_encode([
				"status" => false,
				"mensagem" => "Erro ao atualizar cadastro: " . $stmt->error
			]);
		}

		// Processamento dos cursos
		$cursosProcessados = 0;

		// Itera sobre todos os POST para encontrar os cursos
		foreach ($_POST as $key => $value) {
			// Processa relCursoCadastro (inscrição/desinscrição)
			if (strpos($key, 'relCursoCadastro') === 0) {
				$idCurso = (int) str_replace('relCursoCadastro', '', $key);

				if ($idCurso > 0) {
					$acao = (int) $value;

					if ($acao === 1) { // Inscrito
						// Verifica se já existe o registro
						$checkStmt = $conn->prepare("
											SELECT idRelCursoCadastro
											FROM tbl_curso_cadastro
											WHERE idCadastro = ? AND idCurso = ?
									");
						$checkStmt->bind_param("ii", $idCadastro, $idCurso);
						$checkStmt->execute();
						$checkStmt->store_result();

						if ($checkStmt->num_rows === 0) {
							// Insere novo registro
							$insertStmt = $conn->prepare("
													INSERT INTO tbl_curso_cadastro
													(idCadastro, idCurso, dtCadastroCurso, idSituacao)
													VALUES (?, ?, ?, 1)
											");
							$insertStmt->bind_param("iis", $idCadastro, $idCurso, $dateCad);

							if (!$insertStmt->execute()) {
								throw new Exception("Erro ao inscrever no curso: " . $insertStmt->error);
							}
							$insertStmt->close();
						}
						$checkStmt->close();
					} elseif ($acao === 2) { // Desinscrever-se
						// Remove a inscrição
						$deleteStmt = $conn->prepare("
											DELETE FROM tbl_curso_cadastro
											WHERE idCadastro = ? AND idCurso = ?
									");
						$deleteStmt->bind_param("ii", $idCadastro, $idCurso);

						if (!$deleteStmt->execute()) {
							throw new Exception("Erro ao desinscrever do curso: " . $deleteStmt->error);
						}
						$deleteStmt->close();
					}

					$cursosProcessados++;
				}
			}

			// Processa situações dos cursos
			if (strpos($key, 'situacao') === 0) {
				$parts = explode('_', $key);
				if (count($parts) === 2) {
					$idCursoSituacao = (int) $parts[1];
					$idSituacao = (int) $value;

					if ($idCursoSituacao > 0 && $idSituacao > 0) {
						$situacaoStmt = $conn->prepare("
											UPDATE tbl_curso_cadastro
											SET idSituacao = ?
											WHERE idCadastro = ? AND idCurso = ?
									");
						$situacaoStmt->bind_param("iii", $idSituacao, $idCadastro, $idCursoSituacao);

						if (!$situacaoStmt->execute()) {
							throw new Exception("Erro ao atualizar situação do curso: " . $situacaoStmt->error);
						}
						$situacaoStmt->close();
					}
				}
			}
		}

		// Confirma a transação
		$conn->commit();

		echo json_encode([
			"status" => true,
			"mensagem" => "Cadastro atualizado com sucesso.",
			"idCadastro" => $idCadastro
		]);
	} catch (Exception $e) {
		// Rollback em caso de erro
		//$conn->rollback();

		// Registrar log de erro da exceção
		if (function_exists('registrarLog')) {
			registrarLog("Erro ao atualizar status: " . $e->getMessage());
		}

		http_response_code(500);
		echo json_encode([
			"status" => false,
			"mensagem" => "Erro ao processar atualização: " . $e->getMessage()
		]);

		if (isset($stmt) && $stmt) $stmt->close();
	}
} else {
	echo json_encode([
		"status" => false,
		"mensagem" => "Tipo de operação inválido."
	]);
}

//Fecha a conexão com o banco
mysqli_close($conn);
