<?php

use PSpell\Config;

session_start();

header('Content-Type: application/json; charset=utf-8');

require_once('../includes/conexao.php');
require('../includes/funcoes.php');
require('../includes/configGoogle.php');

$captcha = $_POST['g-recaptcha-response'] ?? '';
$remoteip = $_SERVER['REMOTE_ADDR'] ?? null;
// --- Captura chaves ---
$secret = ConfigGoogle::GOOGLE_RECAPTCHA_SECRET_KEY;
$url = ConfigGoogle::GOOGLE_RECAPTCHA_VERIFY_URL;

$recaptchaResponse = verificarRecaptcha($captcha, $remoteip, $secret, $url);

if ($recaptchaResponse['success'] === false) {
	echo json_encode([
		"status" => false,
		"mensagem" => "Erro ao conectar com a API do Google."
	]);
	exit;
}

if ($recaptchaResponse['score'] < ConfigGoogle::GOOGLE_MIN_SCORE) {
	echo json_encode([
		"status" => false,
		"mensagem" => 'Pontuação reCAPTCHA muito baixa. Possível bot.'
	]);
	exit;
}

// Verificar a resposta
if ($recaptchaResponse['success'] === true) {

	// --- Validação de login e senha ---
	$login = isset($_POST['login']) ? trim($_POST['login']) : '';
	$senha = isset($_POST['senha']) ? trim($_POST['senha']) : '';

	if ($login === '' || $senha === '') {
		echo json_encode(['status' => false, 'mensagem' => 'Login e senha são obrigatórios.']);
		exit;
	}

	// Proteção contra injeção (melhor usar prepared statements!)
	$login = mysqli_real_escape_string($conn, $login);
	$senha = mysqli_real_escape_string($conn, $senha);

	// Consulta segura
	$sql = "SELECT idUsu, nomeUsu, senha FROM tbl_usuarios WHERE login = ? LIMIT 1";
	$stmt = mysqli_prepare($conn, $sql);

	if ($stmt) {
		$stmt->bind_param("s", $login); // "s" para string
		$stmt->execute();
		// Declare as variáveis que vão receber os dados
		$stmt->bind_result($idUsu, $nomeUsu, $senhaDB);

		if ($stmt->fetch()) {
			// Se sua senha está em hash no banco, use password_verify:
			if ($senha === $senhaDB) {
				$_SESSION['__idUsu'] = $idUsu;
				$_SESSION['__nomeUsu'] = $nomeUsu;
				echo json_encode(['status' => true, 'mensagem' => 'Login realizado com sucesso!']);
			} else {
				echo json_encode(['status' => false, 'mensagem' => 'Senha incorreta.']);
			}
		} else {
			echo json_encode(['status' => false, 'mensagem' => 'Usuário não encontrado.']);
		}

		$stmt->close(); // Fecha a consulta
	} else {
		echo json_encode(['status' => false, 'mensagem' => 'Erro na preparação da consulta.']);
	}
} else {
	$errorCodes = $response['error-codes'] ?? ['unknown-error'];
	echo json_encode([
		"status" => false,
		"mensagem" => "Falha na verificação reCAPTCHA.",
		"erros" => $errorCodes
	]);
}

// Libera recursos
$conn->close(); // Fecha a conexão
