<?php
session_start();

header("Content-Type: text/html; charset=utf-8", true);

require_once("includes/conexao.php");
require("includes/funcoes.php");
require("includes/cabecalho.php");
require("includes/configGoogle.php");

$sql = "SELECT idCurso, nomeCurso FROM tbl_curso WHERE status = 1 ORDER BY nomeCurso ASC";
$resultado = mysqli_query($conn, $sql);
$countRow = mysqli_num_rows($resultado);
?>

<div class="container my-5">
	<div class="card shadow p-3 mb-5 bg-body-tertiary rounded">
		<div class="card-body">
			<h3 class="text-center mb-4">Nova Inscrição<br /><span class="required">(*) Para quem nunca se inscreveu para fazer algum curso EAD-ESE da Comunhão</span></h3>
			<form id="frmNovaInscricao"
				class="recaptcha-form"
				method="POST"
				data-sitekey="<?php echo ConfigGoogle::GOOGLE_RECAPTCHA_SITE_KEY; ?>"
				data-url="acoes/confirmar_inscricao.php"
				onsubmit="return fncValidaFormulario(event);">
				<!-- Curso -->
				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">Curso em que deseja se inscrever:</label>
					<div class="col-sm-8">
						<?php
						if ($countRow > 0) {
							$cont = 0;
							while ($rs = mysqli_fetch_array($resultado, MYSQLI_ASSOC)) {
								$id = $rs["idCurso"];
								$nomeCurso = $rs["nomeCurso"];
								echo '<div class="form-check">';
								echo '<input class="form-check-input" type="radio" name="Curso" id="curso_' . $cont . '" value="' . $id . '">';
								echo '<label class="form-check-label" for="curso_' . $cont . '">' . $nomeCurso . '</label>';
								echo '</div>';
								echo '<div id="erroCurso" class="invalid-feedback d-none">Selecione pelo menos um curso.</div>';
								$cont++;
							}
						} else {
							echo "<h5 class='text-danger bold'>Matriculas Fechadas</h5>";
						}
						?>
					</div>
				</div>
				<!-- Nome -->
				<div class="mb-3 row">
					<label for="Nome" class="col-12 col-sm-4 col-form-label text-sm-end">Nome completo: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-7">
						<input type="text" class="form-control" id="Nome" name="Nome" maxlength="100">
						<div class="invalid-feedback d-none">Preencha o nome.</div>
					</div>
				</div>
				<!-- Data de Nascimento -->
				<div class="mb-3 row">
					<label for="DatadeNacimento" class="col-12 col-sm-4 col-form-label text-sm-end">Data de Nascimento:</label>
					<div class="col-12 col-sm-8 col-md-6 col-lg-3">
						<input type="text" class="form-control" id="DatadeNacimento" name="DatadeNacimento" maxlength="10"
							onkeypress="return fncFormatCampos('DatadeNacimento', '99/99/9999', event);">
					</div>
				</div>
				<!-- Telefone Residencial -->
				<div class="mb-3 row">
					<label for="TelResidencial" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Residencial: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" id="TelResidencial" name="TelResidencial" maxlength="20"
							oninput="formatarTelefone(this)">
						<div class="invalid-feedback d-none">Preencha o telefone residencial.</div>
						<small class="form-text text-muted">Ex.: 00 (00) 0000-0000</small>
					</div>
				</div>
				<!-- Telefone Trabalho -->
				<div class="mb-3 row">
					<label for="TelTrabalho" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Trabalho:</label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" id="TelTrabalho" name="TelTrabalho" maxlength="20"
							oninput="formatarTelefone(this)">
						<small class="form-text text-muted">Ex.: 00 (00) 0000-0000</small>
					</div>
				</div>
				<!-- Telefone Celular -->
				<div class="mb-3 row">
					<label for="TelCelular" class="col-12 col-sm-4 col-form-label text-sm-end">Telefone Celular: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" id="TelCelular" name="TelCelular" maxlength="20"
							oninput="formatarTelefone(this)">
						<div class="invalid-feedback d-none">Preencha o telefone celular.</div>
						<small class="form-text text-muted">Ex.: 00 (00) 00000-0000</small>
					</div>
				</div>
				<!-- E-mail -->
				<div class="mb-3 row">
					<label for="Email" class="col-12 col-sm-4 col-form-label text-sm-end">E-mail: <span class="text-danger">*</span></label>
					<div class="col-sm-6">
						<input type="text" class="form-control" id="Email" name="Email" maxlength="50">
						<div id="erroVazio" class="invalid-feedback d-none">Preencha o e-mail.</div>
						<div id="erroInvalido" class="invalid-feedback d-none">Por favor, insira um e-mail válido.</div>
					</div>
				</div>
				<!-- Confirmar E-mail -->
				<div class="mb-3 row">
					<label for="ConfirmarEmail" class="col-12 col-sm-4 col-form-label text-sm-end">Confirmar E-mail: <span class="text-danger">*</span></label>
					<div class="col-sm-6">
						<input type="email" class="form-control" id="ConfirmarEmail" name="ConfirmarEmail" maxlength="50"
							onkeyup="return fncBloqueiCopiaCola(event);" onkeydown="return fncBloqueiCopiaCola(event);">
						<div class="invalid-feedback">Preencha a confirmar e-mail.</div>
					</div>
				</div>
				<!-- Nacionalidade -->
				<div class="mb-3 row">
					<label for="Nacionalidade" class="col-12 col-sm-4 col-form-label text-sm-end">Sua nacionalidade é brasileira? <span class="text-danger">*</span></label>
					<div class="col-sm-8">
						<div class="form-check">
							<input class="form-check-input" type="radio" name="Nacionalidade" id="nacionalidade_1" value="1" onclick="fncHabilitaCampoIdentificador(1, '', '');">
							<label class="form-check-label" for="nacionalidade_1">Sim</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="radio" name="Nacionalidade" id="nacionalidade_2" value="2" onclick="fncHabilitaCampoIdentificador(2, '', '');">
							<label class="form-check-label" for="nacionalidade_2">Não</label>
						</div>
						<div id="erroNacionalidade" class="invalid-feedback d-none">Selecione a nacionalidade.</div>
					</div>
				</div>
				<!-- Identificador style="display: none"-->
				<div id="campoIdentificador"></div>
				<!-- CEP -->
				<div class="mb-3 row">
					<label for="cep" class="col-12 col-sm-4 col-form-label text-sm-end">CEP: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4">
						<div class="input-group">
							<input type="text" class="form-control" id="cep" name="cep" maxlength="10" onkeypress="return fncFormatCampos('cep', '99.999-999', event);">
							<button class="btn btn-primary" type="button" onclick="buscarCep(this.value);">Pesquisar CEP</button>
						</div>
						<small class="form-text text-muted">Ex.: 00.000-000</small>
						<div class="invalid-feedback">Preencha o CEP.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Pais" class="col-12 col-sm-4 col-form-label text-sm-end">País: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-3">
						<input type="text" class="form-control" name="Pais" id="Pais" maxlength="50">
						<div class="invalid-feedback">Preencha o país.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Endereco" class="col-12 col-sm-4 col-form-label text-sm-end">Endereço:<span class="text-danger">*</span></label>
					<div class="col-sm-8">
						<input type="text" class="form-control" name="Endereco" id="Endereco" maxlength="150">
						<div class="invalid-feedback">Preencha o endereço.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Complemento" class="col-12 col-sm-4 col-form-label text-sm-end">Complemento:</label>
					<div class="col-12 col-sm-8 col-md-5">
						<input type="text" class="form-control" name="Complemento" id="Complemento" maxlength="200">
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Cidade" class="col-12 col-sm-4 col-form-label text-sm-end">Cidade: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-5">
						<input type="text" class="form-control" name="Cidade" id="Cidade" maxlength="50">
						<div class="invalid-feedback">Preencha a cidade.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="Bairro" class="col-12 col-sm-4 col-form-label text-sm-end">Bairro: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-5">
						<input type="text" class="form-control" name="Bairro" id="Bairro" maxlength="50">
						<div class="invalid-feedback">Preencha o bairro.</div>
					</div>
				</div>

				<div class="mb-3 row">
					<label for="UF" class="col-12 col-sm-4 col-form-label text-sm-end text-uppercase">UF: <span class="text-danger">*</span></label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" name="UF" id="UF" maxlength="2">
						<div class="invalid-feedback">Preencha o UF.</div>
					</div>
				</div>
				<!-- Quanto tempo na doutrina -->
				<div class="mb-3 row">
					<label for="QuantoTemponaDoutrina" class="col-12 col-sm-4 col-form-label text-sm-end">Quanto tempo na doutrina?</label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" id="QuantoTemponaDoutrina" name="QuantoTemponaDoutrina" maxlength="50">
					</div>
				</div>
				<!-- Atividade Profissional -->
				<div class="mb-3 row">
					<label for="AtividadeProfissiona" class="col-12 col-sm-4 col-form-label text-sm-end">Atividade profissional:</label>
					<div class="col-12 col-sm-8 col-md-4 col-lg-2">
						<input type="text" class="form-control" id="AtividadeProfissiona" name="AtividadeProfissiona" maxlength="50">
					</div>
				</div>
				<!-- Escolaridade -->
				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">Escolaridade <span class="text-danger">*</span></label>
					<div class="col-sm-8 pt-2">
						<div class="form-check">
							<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_0" value="Fundamental">
							<label class="form-check-label" for="Escolaridade_0">Fundamental</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_1" value="Secundária">
							<label class="form-check-label" for="Escolaridade_1">Secundária</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="checkbox" name="Escolaridade" id="Escolaridade_2" value="Universitária">
							<label class="form-check-label" for="Escolaridade_2">Universitária</label>
						</div>
					</div>
				</div>
				<!-- Dispõe de 5 horas por semana -->
				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">Dispõe de 5 horas por semana? <span class="text-danger">*</span></label>
					<div class="col-sm-8">
						<div class="form-check">
							<input class="form-check-input" type="radio" name="DispoeSemana" id="dispoeSemana_0" value="1">
							<label class="form-check-label" for="dispoeSemana_0">Sim</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="radio" name="DispoeSemana" id="dispoeSemana_1" value="0">
							<label class="form-check-label" for="dispoeSemana_1">Não</label>
						</div>
					</div>
					<div id="erroDispoeSemana" class="invalid-feedback d-none">Informe sua disponibilidade na semana.</div>
				</div>
				<!-- Força maior -->
				<div class="mb-3 row">
					<label class="col-12 col-sm-4 col-form-label text-sm-end">Compromete-se a só sair por força maior? <span class="text-danger">*</span></label>
					<div class="col-sm-8">
						<div class="form-check">
							<input class="form-check-input" type="radio" name="ProblemaForcaMaior" id="problemaForcaMaior_0" value="1">
							<label class="form-check-label" for="problemaForcaMaior_0">Sim</label>
						</div>
						<div class="form-check">
							<input class="form-check-input" type="radio" name="ProblemaForcaMaior" id="problemaForcaMaior_1" value="0">
							<label class="form-check-label" for="problemaForcaMaior_1">Não</label>
						</div>
					</div>
					<div for="erroProblemaForcaMaior" class="invalid-feedback d-none">Preencha o compromisso.</div>
				</div>
				<!-- Botão Enviar -->
				<div class="text-center">
					<button type="submit" class="btn btn-primary" id="inscrevame">Inscreva-me no EAD</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php
//Liberar o conjunto de resultados
mysqli_free_result($resultado);
//Fecha a conexão com o banco
mysqli_close($conn);

require_once("includes/rodape.php");
?>

<script>
	$(document).ready(function() {
		disableAllFormFields('frmNovaInscricao', <?php echo $countRow; ?>);
	});
</script>