<?php  
	header("Content-Type: text/html; charset=utf-8", true);
	require_once("includes/cabecalho.php");
?>

<style>
  body {
    background-color: #F7F6F1;
    font-family: "Verdana", sans-serif;
  }
  h1, h2, h3 {
    color: #3333FF;
  }
  .section-title {
    margin-top: 40px;
  }
</style>

<script>

</script>

<div class="container my-5">
  <div class="card shadow p-3 mb-5 bg-body-tertiary rounded">
    <div class="card-body">
      <h2 class="text-center mb-5">Educação a Distância (EAD) na Comunhão Espírita de Brasília</h2>
      <form id="frmEad" method="POST">
        <div class="mb-4">
          <h4 class="section-title">O PROJETO</h4>
          <p>Desde 2007, a Comunhão Espírita de Brasília desenvolve cursos a distância (EAD) com metodologia própria, aplicando-os em diversos capítulos do Evangelho Segundo o Espiritismo. Já foram formados mais de 1.600 alunos até 2018.</p>
        </div>

        <div class="mb-4">
          <h4 class="section-title">Os Cursos</h4>
          <p>Os cursos são independentes, baseados em capítulos do Evangelho, e desenvolvidos para promover reflexão e prática da mensagem de Jesus. Eles ocorrem 2 vezes ao ano.</p>
        </div>

        <div class="mb-4">
          <h4 class="section-title">Objetivos</h4>
          <p>Compreender os conceitos do capítulo estudado e aplicar os ensinamentos na vida pessoal.</p>
        </div>

        <div class="mb-4">
          <h4 class="section-title">Público-Alvo</h4>
          <ul>
            <li>Idade mínima: 16 anos</li>
            <li>Leitura e escrita em português</li>
            <li>Acesso à internet</li>
            <li>Compromisso com a conclusão</li>
          </ul>
        </div>

        <div class="mb-4">
          <h4 class="section-title">Curso de Formação de Tutores</h4>
          <p>Capacita alunos para atuarem como tutores voluntários nos cursos EAD. Exige experiência prévia em um dos cursos do ESE.</p>
        </div>

        <div class="mb-4">
          <h4 class="section-title">Calendário de Atividades</h4>
          <ul>
            <li><strong>1º Semestre</strong>: Inscrições até 21/02, aulas de 07/03 a 11/07</li>
            <li><strong>2º Semestre</strong>: Inscrições até 17/07, aulas de 01/08 a 05/12</li>
          </ul>
          <p><em><span class="text-danger">*Cursos com vagas preenchidas poderão sair temporariamente da oferta.</span></em></p>
        </div>

        <div class="mb-5 text-center">
          <h3>Inscreva-se</h3>
          <p>Escolha abaixo a opção que melhor se encaixa no seu caso:</p>
        </div>
        <!-- Botões -->
				<div class="text-center mt-4">
          <button type="button" id="btnNovaInscricao" class="btn btn-primary" onclick="fncNovaInscricao();">Primeiro curso</button>
          <button type="button" id="btnJaSoInscrido" class="btn btn-secondary" onclick="fncInscricaoExistente();">Já fiz outro curso</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php
	include_once("includes/rodape.php");
?>