// Função para validar e-mails
function fncValidaMail(id, erroVazio, erroInvalido) {
  const inputEmail = document.getElementById(id);
  const regex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
  const email = regex.test(inputEmail.value);

  if (!email) {
    //inputEmail.classList.add("is-invalid");
    // const feedback = inputEmail.nextElementSibling;
    // if (feedback && feedback.classList.contains("invalid-feedback")) {
    //   feedback.classList.remove("d-none");
    // }
    erroVazio.classList.add("is-invalid");
    erroInvalido.classList.remove("d-none");
    return (valido = false);
  }
}

// Função para validar o nome completo do usuário.
function fncValidaNomeCompleto(nome) {
  var separado = nome.split(" ");
  var totalSeparador = separado.length;
  if (totalSeparador <= 1) {
    return false;
  } else {
    return true;
  }
}

// Habilitar o campo de Identificacao
function fncHabilitaCampoIdentificador(
  nacionalidade,
  identificacao = "",
  status = ""
) {
  const campoIdentificador = document.getElementById("campoIdentificador");

  if (!campo) return; // evita erro caso o elemento não exista

  // Escapa aspas simples e duplas no valor
  const safeIdentificacao = String(identificacao)
    .replace(/"/g, "&quot;")
    .replace(/'/g, "&#39;");

  // Determina o label de acordo com a nacionalidade
  const labelTexto =
    nacionalidade == 1 ? "Inclua seu CPF" : "Inclua o número de sua identidade";

  // Monta o HTML do campo
  campoIdentificador.innerHTML = `
    <div class="mb-3 row">
      <label for='identificacao' class='col-12 col-sm-4 col-form-label text-sm-end'>${labelTexto}: <span class='text-danger'>*</span></label>
      <div class="col-sm-4">
        <input 
          type="text"
          class="form-control"
          name="Identificacao"
          id="Identificacao"
          value="${safeIdentificacao}"
          maxlength="20"
          ${status}
        />
      </div>
    </div>
  `;
}

// Função para alertar o usuário sobre a disposição do tempo para o curso. Caso seje não o usuário receberar um mensagem de alerta e será redirecionado.
function fncNaoDispoetempo(cod) {
  if (cod == 0) {
    alert(
      "Como explicado nas informações apresentadas neste site, você precisará dedicar, aproximadamente 5 horas por semana para o curso. Favor confirmar essa disponibilidade de tempo para que possamos aceitar sua inscrição."
    );

    document.getElementById("btnEnviar").disabled = true;
    document.getElementById("btnEnviar").className = "btnDisabled";
  } else {
    document.getElementById("btnEnviar").disabled = false;
    document.getElementById("btnEnviar").className = "btn";
  }
}

// Função para alertar o usuário sobre o compremetimento do para o curso.
function fncProblemaDeForcaMaior(cod) {
  if (cod == 0) {
    alert(
      "Como explicado nas informações apresentadas neste site, as vagas para este curso são limitadas. Ao responder “SIM” a esta pergunta, você estará assumindo compromisso de se esforçar para aproveitar a vaga que lhe for concedida e permanecer no curso até o final, a não ser em caso de força maior."
    );

    document.getElementById("btnEnviar").disabled = true;
    document.getElementById("btnEnviar").className = "btnDisabled";
  } else {
    document.getElementById("btnEnviar").disabled = false;
    document.getElementById("btnEnviar").className = "btn";
  }
}

// Formata um campo do formulário de acordo com a máscara informada...
/* 
	
* Parâmetros: - objForm (o Objeto Form)
	
* - strField (string contendo o nome do textbox) - sMask (mascara que define o * formato que o dado será apresentado, * usando o algarismo "9" para  definir números e o símbolo "!" para  qualquer caracter...  - evtKeyPress (evento) Uso.......: <input type="textbox"  name="xxx".... onkeypress="return txtBoxFormat(document.rcfDownload, 'str_cep', '99999-999', event);">
	
* Observação: As máscaras podem ser representadas como os exemplos abaixo:
	
* CEP -> 99.999-999
	
* CPF -> 999.999.999-99
	
* CNPJ -> 99.999.999/9999-99
	
* Data -> 99/99/9999
	
* Tel Resid -> (99) 999-9999
	
* Tel Cel -> (99) 9999-9999
	
* Processo -> 99.999999999/999-99
	
* C/C -> 999999-!
	
* E por aí vai...
	
*/

function fncFormatCampos(strField, mascara, evt) {
  const tecla = evt.key;

  // Ignorar teclas de controle
  if (
    tecla === "Backspace" ||
    tecla === "Tab" ||
    tecla === "Shift" ||
    evt.ctrlKey ||
    evt.metaKey ||
    evt.key.length > 1
  )
    return true;

  // Apenas números são permitidos
  if (!/^\d$/.test(tecla)) return false;

  const input = document.getElementById(strField);
  let valor = input.value.replace(/\D/g, ""); // Remove tudo que não for número

  if (valor.length >= mascara.replace(/[^9]/g, "").length) return false; // Limita ao número de dígitos

  valor += tecla;

  let resultado = "";
  let pos = 0;

  for (let i = 0; i < mascara.length; i++) {
    if (mascara[i] === "9") {
      if (valor[pos]) {
        resultado += valor[pos++];
      } else {
        break;
      }
    } else {
      resultado += mascara[i];
    }
  }

  input.value = resultado;
  return false; // Impede que o caractere seja inserido normalmente
}

function fncBloqueiCopiaCola(event) {
  var ctrl =
    typeof event.modifiers == "undefined"
      ? event.ctrlKey
      : event.modifiers & event.CONTROL_MASK;

  var v =
    typeof event.which == "undefined" ? event.keyCode == 86 : event.which == 86;

  // If the control and 'V' keys are pressed at the same time

  if (ctrl && v) {
    document.forms["frmNovaInscricao"].elements["ConfirmarEmail"].value = "";
    return false;
  }

  return true;
}

function fncOrdena() {
  var objFormulario = document.getElementById("frm_listegem");
  var ordena = document.getElementById("ordena").value;

  objFormulario.submit();
}

function fncLimiteDeRegistros() {
  var objFormulario = document.getElementById("frm_listegem");
  var numeroDeRegistros = document.getElementById("numeroDeRegistros").value;

  objFormulario.submit();
}

function isNumeric(str) {
  const numericRegex = /^\d+$/; // \d is shorthand for [0-9]
  return numericRegex.test(str);
}

function fncPesquisa() {
  const form = document.getElementById("frm_pesquisa");
  const searchInput = document.getElementById("txtPesquisar");
  console.log("searchInput" + searchInput);
  const searchName = searchInput.value.trim();
  console.log("searchName" + searchName);
  const searchTypeCheckboxes = document.getElementsByName("TipoPesquisa");
  console.log("searchTypeCheckboxes" + searchTypeCheckboxes);

  // --- Validate Checkbox Selection ---
  const isCheckboxSelected = Array.from(searchTypeCheckboxes).some(
    (chk) => chk.checked
  );

  if (!isCheckboxSelected) {
    alert("Campo vazio:\nSelecione o campo de opção de pesquisa!");
    return; // Exit the function early if no checkbox is selected
  }

  // --- Determine Search Parameters ---
  let finalSearchValue;
  let searchParameterType;

  const isInputNumeric = isNumeric(searchName);

  if (isInputNumeric) {
    finalSearchValue = searchName;
    searchParameterType = 1; // Numeric search
  } else {
    // Assuming " - " is always the delimiter when the input is not purely numeric
    const parts = searchName.split(" - ");
    finalSearchValue = parts[0].trim();
    searchParameterType = 2; // Non-numeric search (e.g., name search)
  }

  // --- Handle Form Submission ---
  if (searchName === "Não existe o registro pesquisado!") {
    form.action = "frm_pesquisar.php?r=3";
  } else {
    // Use URLSearchParams for robust URL construction
    const params = new URLSearchParams();
    params.append("str", finalSearchValue);
    params.append("acao", "e");
    params.append("tpPeq", searchParameterType);
    form.action = `frm_inscricao_detalhas.php?${params.toString()}`;
  }

  form.submit();
}

function fncSituacao(valorCombo, idCurso, idCadastro) {
  var objFormulario = document.getElementById("frmInscricaoDetalha");
  //A variável valorCombo o valor randCod do php, depois ele é concatenada com a strig situacao para gerar o mesmo id do select, dessa forma é possivel reculperar o valor real.
  var combo = "situacao" + valorCombo;
  var idComb = document.getElementById(combo).value;
  var idRel = idCurso;
  var idCad = idCadastro;

  objFormulario.action =
    "acoes/confirmar_inscricao_detalhas.php?tipo=U&idComb=" +
    idComb +
    "&idCurso=" +
    idCurso +
    "&idCad=" +
    idCad;

  objFormulario.submit();
}

function fncRelCursoCadastro(idCurso, idCadastro) {
  var objFormulario = document.getElementById("frmInscricaoDetalha");
  var idCur = idCurso;
  var idCad = idCadastro;

  var conctenaIdRelCursoCadastro = document.getElementById(
    "relCursoCadastro" + idCur
  ).value;

  objFormulario.action =
    "acoes/confirmar_inscricao_detalhas.php?tipo=UE&idCurso=" +
    idCur +
    "&idCad=" +
    idCad +
    "&conctenaIdRelCursoCadastro=" +
    conctenaIdRelCursoCadastro;

  objFormulario.submit();
}

//Função para gerar relatório de matriculas.
function getRelatorioMatriculas() {
  $.ajax({
    type: "POST",
    async: false,
    cache: false,
    dataType: "html",
    beforeSend: function () {
      loader();
    },
    success: function () {
      window.location = "frm_relatorio_para_matricula.php";
    },
    complete: function () {
      $("#loading").remove();
    },
    error: function (e) {
      console.log(e);
    },
  });
}

//Carregar página cadastrar usuários
function getRelatorioGeral() {
  $.ajax({
    type: "POST",
    async: false,
    cache: false,
    dataType: "html",
    beforeSend: function () {
      loader();
    },
    success: function () {
      window.location = "frm_relatorio_geral.php";
    },
    complete: function () {
      $("#loading").remove();
    },
    error: function (e) {
      console.log(e);
    },
  });
}

//Carregar página cadastrar usuários
function getRelatorioQuantitativo() {
  $.ajax({
    type: "POST",
    async: false,
    cache: false,
    //dataType: 'html',
    beforeSend: function () {
      loader();
    },
    success: function () {
      window.location = "frm_relatorio_quantitativo.php";
    },
    complete: function () {
      $("#loading").remove();
    },
    error: function (e) {
      console.log(e);
    },
  });
}

function loader() {
  var html = "<img src='images/ajax_loader.gif' />";
  return $("#loading").append(html);
}

function buscarCep(input) {
  var input = document.getElementById("cep").value;
  var cep = input.replace(/\D/g, "");

  if (cep != "") {
    fetch(`https://viacep.com.br/ws/${cep}/json/`)
      .then((response) => response.json())
      .then((data) => {
        if (data.erro) {
          alert("CEP não encontrado.");
          return;
        }
        document.getElementById("cep").value = data.cep;
        document.getElementById("Bairro").value = data.bairro;
        document.getElementById("Complemento").value = data.complemento;
        document.getElementById("Cidade").value = data.localidade;
        document.getElementById("Endereco").value = data.logradouro;
        document.getElementById("UF").value = data.uf;
      })
      .catch((error) => {
        notificacao("Erro ao buscar o CEP.", "error");
        //console.error("Erro:", error);
      });
  } else {
    notificacao("CEP invalido! Consulta novamente.", "warning");
  }
}

function fncNovaInscricao() {
  window.location.href = "frm_inscricao_nova.php";
}

function fncJaSoInscrido() {
  window.location.href = "frm_inscricao_existente.php?tipo=E";
}

function fncGerarExcel() {
  window.location.href = "frm_excel.php";
}

function fncInscricaoExistente() {
  window.location.href = "acoes/logout_inscricao.php";
}

function notificacao(mensagem, tipo) {
  $.notify(mensagem, {
    allow_dismiss: true,
    className: tipo,
    position: "top right",
    autoHideDelay: 5000,
    showDuration: 500,
    clickToHide: false,
  });
}

// Função para redirecionar para a página de detalhe de inscrição de aluno. Recebe o ID da cadastro
function inscricaoDetalhas(idCadastro) {
  window.location.href = `frm_inscricao_detalhas.php?id=${idCadastro}`;
}

// Função de deletar inscrição de aluno
function deletarInscricao(idCadastro) {
  var status = confirm("Deseja deletar o aluno?");
  if (status) {
    $.ajax({
      url: "acoes/deletar_aluno.php",
      type: "POST",
      data: {
        idCadastro: idCadastro,
        acao: "d",
      },
      success: function (response) {
        $.notify(resposta.mensagem, resposta.status);
        console.log(response);
      },
      error: function (xhr, status, error) {
        console.error("Erro ao carregar o curso:", error);
      },
    });
  }
}

// Função para validar variáveis
function isNullOrWhiteSpace(value) {
  return value === null || value === "" || value === undefined;
}

// Função para esconder modal, recarregar datatables, limpar mensagens
function fecharModal(tempo, modal) {
  if (!isNullOrWhiteSpace(tempo) && !isNullOrWhiteSpace(modal)) {
    window.setTimeout(function () {
      $("#" + modal).modal("hide"); //Fechar modal
    }, tempo);
  }
}
