$(document).ready(function () {
  renderizarDesignDataTablesAlteracaoStatus();
});

function renderizarDesignDataTablesAlteracaoStatus() {
  var tabela = $("#tblAlteracaoStatus").DataTable({
    ajax: {
      url: "acoes/consultar_alteracao_status.php",
      type: "POST",
      data: function (d) {
        d.nome = $("#filtroNome").val();
        d.curso = $("#filtroCurso").val();
        d.situacao = $("#filtroSituacao").val();
      },
      dataSrc: "data",
    },
    columns: [
      { data: "idCadastro" },
      { data: "inscricao" },
      { data: "nome" },
      { data: "cursos" },
      { data: "datas" },
      { data: "situacoes" },
      {
        data: "idRelCursoCadastro",
      },
    ],
    oLanguage: {
      sLengthMenu: "_MENU_",
      sInfo:
        "Mostrando <strong>_START_</strong>-<strong>_END_</strong> de <strong>_TOTAL_</strong> registros",
      sInfoFiltered: "(Filtro de _MAX_ registros)",
      sZeroRecords: "Nenhum registro encontrado",
      sProcessing: "Processando",
      sLoadingRecords: "Nenhum registro encontrado",
      sInfoEmpty:
        "Mostrando <strong>_START_</strong>-<strong>_END_</strong> de <strong>_TOTAL_</strong> registros",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    buttons: [], // Define um array vazio, removendo todos os botões
    paging: true, // Habilita a paginação (agora client-side)
    info: true, // Habilita a informação de registros
    lengthChange: true, // Habilita o seletor de "Mostrar X entradas"
    processing: true,
    serverSide: false,
    responsive: true,
    autoWidth: true,
    destroy: true,
    ordering: false,
    stateSave: false,
    displayLength: 10,
    pageLength: 50,
    lengthMenu: [
      [50, 100, 250, 500, -1],
      [50, 100, 250, 500, "Todos"],
    ],
    searching: false,
    dom: "<'row'<'col-sm-12'<'text-center bg-body-light mb-2'B>>><'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>><'row'<'col-sm-12'tr>><'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
    renderer: "bootstrap",
    sType: "brazilian",
    columnDefs: [
      { orderable: false, targets: [6] }, // Ações sem ordenação
      { targets: [0, 1, 4, 5], className: "text-center" }, // idCadastro, inscrição
      { targets: [2, 3], className: "text-start" }, // nome, email, cidade
    ],
  });

  // Eventos dos filtros
  $("#filtroNome, #filtroCurso, #filtroSituacao").on(
    "input change",
    function () {
      tabela.ajax.reload();
    }
  );

  $("#select-all").on("click", function () {
    $(".row-checkbox").prop("checked", this.checked);
  });
}

function fncAtualizaStatus(event) {
  event.preventDefault();

  const form = document.getElementById("frmAtualizaStatus");

  const selecionados = Array.from(
    document.querySelectorAll(".row-checkbox:checked")
  ).map((cb) => cb.value);

  const novoStatus = document.getElementById("novoSituacao")?.value;

  const filtroSituacao = document.getElementById("filtroSituacao")?.value;

  if (selecionados.length === 0) {
    notificacao("Por favor, selecione pelo menos um inscrito.", "error");
    return;
  }

  if (novoStatus === "") {
    notificacao("Por favor, selecione o novo status.", "error");
    return;
  }

  if (filtroSituacao === "") {
    notificacao("Por favor, selecione atual status.", "error");
    return;
  }

  $.ajax({
    url: "acoes/alterar_situacao_inscricao.php",
    type: "POST",
    dataType: "JSON",
    data: {
      selecionados: selecionados,
      novoStatus: novoStatus,
    },
    success: function (resposta) {
      if (resposta.status) {
        notificacao(resposta.mensagem, "success");
        form.reset();
        renderizarDesignDataTablesAlteracaoStatus();
      } else {
        notificacao(resposta.mensagem, "error");
      }
    },
    error: function (xhr) {
      // Esta parte do código roda se houve qualquer tipo de erro no servidor
      try {
        // Tenta pegar a mensagem de erro que vem do PHP
        var erro = JSON.parse(xhr.responseText);
        console.log(erro.mensagem);
      } catch (e) {
        // Se a resposta não for um JSON, mostra uma mensagem genérica
        console.log(
          "Erro desconhecido. Verifique o console para mais detalhes."
        );
        console.log(xhr.responseText);
      }
    },
  });
}
