$(document).ready(function () {
  renderizarDesignDataTables();
});

function renderizarDesignDataTables() {
  $("#tblCursos").DataTable({
    ajax: {
      url: "acoes/consultar_cursos.php",
      type: "POST",
      dataSrc: "data",
    },
    columns: [
      { data: "idCurso" },
      { data: "nomeCurso" },
      { data: "siglaCurso" },
      { data: "descricaoCurso" },
      { data: "dtCadastroCurso" },
      {
        data: "status", // Supondo que você tem uma coluna 'status' nos seus dados
        render: function (data, type, row) {
          if (type === "display") {
            if (data === "1") {
              // Ou 'ativo', 'sim', 1, etc.
              return '<div class="text-center"><i class="bi bi-check-circle-fill text-success"></i></div>';
            } else {
              return '<div class="text-center"><i class="bi bi-x-circle-fill text-danger"></i></div>';
            }
          }
          return data; // Para ordenação e filtros, retorne o dado original
        },
      },
      {
        data: "idCurso",
        render: function (data, type, row) {
          return `
            <div class="d-inline-flex gap-1">
              <button class="btn btn-sm btn-primary editar-btn" data-id="${data}">
                <i class="bi bi-pencil-fill"></i>
              </button>
              <button class="btn btn-sm btn-danger excluir-btn" data-id="${data}">
                <i class="bi bi-trash-fill"></i>
              </button>
            </div>
          `;
        },
      },
    ],
    oLanguage: {
      sLengthMenu: "_MENU_",
      sInfo:
        "Mostrando <strong>_START_</strong>-<strong>_END_</strong> de <strong>_TOTAL_</strong> registros",
      sInfoFiltered: "(Filtro de _MAX_ registros)",
      sSearch: "Pesquisar: ",
      sZeroRecords: "Nenhum registro encontrado",
      sProcessing: "Processando",
      sLoadingRecords: "Nenhum registro encontrado",
      sInfoEmpty:
        "Mostrando <strong>_START_</strong>-<strong>_END_</strong> de <strong>_TOTAL_</strong> registros",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    buttons: [], // Define um array vazio, removendo todos os botões
    paging: true, // Habilita a paginação (agora client-side)
    info: true, // Habilita a informação de registros
    lengthChange: true, // Habilita o seletor de "Mostrar X entradas"
    processing: true,
    serverSide: false,
    responsive: true,
    autoWidth: true,
    destroy: true,
    ordering: false,
    stateSave: false,
    displayLength: 10,
    pageLength: 5,
    lengthMenu: [
      [5, 10, 25, 50, -1],
      [5, 10, 25, 50, "Todos"],
    ],
    dom: "<'row'<'col-sm-12'<'text-center bg-body-light mb-2'B>>><'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>><'row'<'col-sm-12'tr>><'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
    renderer: "bootstrap",
    sType: "brazilian",
    columnDefs: [
      { orderable: false, targets: [6] }, // Ações sem ordenação
      { targets: [0, 2, 4, 5, 6], className: "text-center" }, // idCadastro, inscrição
      { targets: [1, 3], className: "text-start" }, // nome, email, cidade
    ],
  });

  // Clique em Editar
  $("#tblCursos tbody").on("click", ".editar-btn", function () {
    const idCurso = $(this).data("id");
    if (idCurso) {
      editarModelCurso(idCurso);
    } else {
      console.warn("ID do curso não encontrado");
    }
  });

  // Clique em Excluir
  $("#tblCursos").on("click", ".excluir-btn", function () {
    const idCurso = $(this).data("id");
    if (idCurso) {
      excluirCurso(idCurso);
    } else {
      console.warn("ID do curso não encontrado");
    }
  });
}

function editarModelCurso(idCurso) {
  if (!idCurso) {
    console.warn("ID do curso inválido.");
    return;
  }

  $.ajax({
    url: "manter_curso.php",
    type: "GET",
    data: {
      idCurso: idCurso,
      acao: "e",
    },
    dataType: "html",
    success: function (response) {
      $("#modalCurso").html("");
      $("#modalCurso").html(response);
      $("#modal-curso").modal("show");
    },
    error: function (error) {
      console.error("Erro ao carregar o curso:", error);
    },
  });
}

function excluirCurso(idCurso) {
  if (!idCurso) {
    console.warn("ID do curso inválido.");
    return;
  }

  $.ajax({
    url: "acoes/confirmar_curso.php",
    type: "POST",
    data: {
      idCurso: idCurso,
      acao: "d",
    },
    success: function (response) {
      $.notify(response.mensagem, "success");
      renderizarDesignDataTables();
    },
    error: function (xhr, status, error) {
      console.error("Erro ao carregar o curso:", error);
    },
  });
}

function fncValidarFormCurso(event) {
  event.preventDefault();

  const form = event.target;

  const idCursoInput = document.getElementById("idCurso");
  const nomeCursoInput = document.getElementById("NomeCurso");
  const siglaCursoInput = document.getElementById("SiglaCurso");
  const descricaoCursoInput = document.getElementById("Descricao");
  const statusCursoInput =
    document.querySelector('input[name="Status"]:checked')?.value || "";

  const idCurso = idCursoInput.value.trim();
  const nomeCurso = nomeCursoInput.value.trim();
  const siglaCurso = siglaCursoInput.value.trim();
  const descricaoCurso = descricaoCursoInput.value.trim();
  const statusCurso = statusCursoInput;

  let tipo = null;

  if (parseInt(idCurso) === 0 || idCurso === "") {
    tipo = "i";
  } else {
    tipo = "e";
  }

  let valido = true;

  nomeCursoInput.classList.remove("is-invalid");
  //siglaCursoInput.classList.remove("is-invalid");
  descricaoCursoInput.classList.remove("is-invalid");

  if (nomeCurso === "") {
    nomeCursoInput.classList.add("is-invalid");
    valido = false;
  } else {
    nomeCursoInput.classList.remove("is-invalid");
  }

  if (descricaoCurso === "") {
    descricaoCursoInput.classList.add("is-invalid");
    valido = false;
  } else {
    descricaoCursoInput.classList.remove("is-invalid");
  }

  if (!valido) return false;

  $.ajax({
    url: "acoes/confirmar_curso.php",
    type: "POST",
    dataType: "JSON",
    data: {
      acao: tipo,
      idCurso: idCurso,
      nomeCurso: nomeCurso,
      descricao: descricaoCurso,
      siglaCurso: siglaCurso,
      status: statusCurso,
    },
    success: function (response) {
      if (response.status) {
        notificacao(response.mensagem, "success");
        renderizarDesignDataTables();
        if (tipo === "i") {
          form.reset();
        } else {
          fecharModal(0, "modal-curso");
        }
      } else {
        notificacao(response.mensagem, "error");
      }
    },
    error: function (error) {
      console.log(error);
      notificacao("Erro de comunicação com o servidor.", "error");
    },
  });
}
