// Cookies utilitários
function getCookie(nome) {
  const cookies = document.cookie.split(";");
  for (let c of cookies) {
    c = c.trim();
    if (c.startsWith(nome + "=")) {
      return c.substring(nome.length + 1);
    }
  }
  return "";
}

function setCookie(nome, valor, dias) {
  const d = new Date();
  d.setTime(d.getTime() + dias * 24 * 60 * 60 * 1000);
  document.cookie = `${nome}=${valor}; expires=${d.toUTCString()}; path=/`;
}

function deleteCookie(nome) {
  document.cookie = `${nome}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;`;
}

// Preenche login salvo (cookie)
window.onload = () => {
  const loginSalvo = getCookie("loginSalvo");
  if (loginSalvo !== "") {
    document.getElementById("login").value = loginSalvo;
    document.getElementById("lembrarLogin").checked = true;
  }
};

function fncLogin(event) {
  event.preventDefault();

  const form = event.target.closest("form");
  const formData = new FormData(form);

  const login = document.getElementById("login");
  const senha = document.getElementById("senha");
  const lembrar = document.getElementById("lembrarLogin");

  const siteKey = form.dataset.sitekey;
  const urlDestino = form.dataset.url;

  let valido = true;

  // --- Validação dinâmica ---
  if (login.value.trim() === "") {
    login.classList.add("is-invalid");
    login.classList.remove("is-valid");
    valido = false;
  } else {
    login.classList.remove("is-invalid");
    login.classList.add("is-valid");
  }

  if (senha.value.trim() === "") {
    senha.classList.add("is-invalid");
    senha.classList.remove("is-valid");
    valido = false;
  } else {
    senha.classList.remove("is-invalid");
    senha.classList.add("is-valid");
  }

  if (!valido) return;

  grecaptcha.ready(async () => {
    try {
      const token = await grecaptcha.execute(siteKey, { action: "login" });

      // monta dados para enviar
      const dados = {
        login: login.value,
        senha: senha.value,
        "g-recaptcha-response": token,
      };

      $.ajax({
        url: urlDestino,
        type: "POST",
        dataType: "json",
        data: dados,
        success: function (resposta) {
          if (resposta.status) {
            if (lembrar.checked) {
              setCookie("loginSalvo", login.value, 30);
            } else {
              deleteCookie("loginSalvo");
            }

            window.location.href = "frm_home.php";
          } else {
            $.notificacao(resposta.mensagem || "Login inválido", "error");
          }
        },
        error: function (xhr, status, error) {
          console.log("Erro:", error);
          notificacao("Erro ao conectar com o servidor.", "error");
        },
      });
    } catch (err) {
      console.error("Erro ao executar reCAPTCHA:", err);
      notificacao("Erro no reCAPTCHA.", "error");
    }
  });
}
