<?php

// $moodleUrl = 'https://estudo.eseead.com.br/ese5/webservice/rest/server.php';
// $token = 'c908732dbf4e9c6a9c1afecaaab4dcfa';

/**
 * Exemplo: usar core_role_assign_roles para atribuir um papel a um usuário em um curso
 * Compatível com Moodle 4.x e 5.x
 */


// // ======================================================
// // Função genérica para chamada REST
// // ======================================================
// function call_moodle_api(string $function, array $params, string $token, string $moodleUrl): mixed
// {
//   $url = "{$moodleUrl}/webservice/rest/server.php?wstoken={$token}&wsfunction={$function}&moodlewsrestformat=json";

//   $ch = curl_init($url);
//   curl_setopt_array($ch, [
//     CURLOPT_RETURNTRANSFER => true,
//     CURLOPT_POST           => true,
//     CURLOPT_POSTFIELDS     => http_build_query($params),
//     CURLOPT_TIMEOUT        => 30,
//   ]);

//   $response = curl_exec($ch);
//   $error = curl_error($ch);
//   curl_close($ch);

//   if ($error) {
//     throw new Exception("Erro cURL: $error");
//   }

//   $decoded = json_decode($response, true);
//   if (isset($decoded['exception'])) {
//     throw new Exception("Erro Moodle: {$decoded['message']} ({$decoded['errorcode']})");
//   }

//   return $decoded;
// }

// // ======================================================
// // Parâmetros de exemplo
// // ======================================================

// // ID do papel (roleid)
// $roleId = 5; // 5 = aluno, 3 = professor, 1 = admin (confirme no seu Moodle)

// // ID do usuário já existente no Moodle
// $userId = 17; // substitua pelo ID real do usuário retornado em core_user_create_users

// // ID do curso onde será atribuído o papel
// $courseId = 23; // substitua pelo ID real do curso

// // ======================================================
// // Montar o array assignments
// // ======================================================
// $params = [
//   'assignments' => [
//     [
//       'roleid'       => $roleId,
//       'userid'       => $userId,
//       'contextid'    => 0, // pode deixar 0 se usar contextlevel + instanceid
//       'contextlevel' => 'course',
//       'instanceid'   => $courseId
//     ]
//   ]
// ];

// try {
//   $result = call_moodle_api('core_role_assign_roles', $params, $token, $moodleUrl);
//   echo "✅ Papel atribuído com sucesso ao usuário ID {$userId} no curso {$courseId}\n";
//   print_r($result);
// } catch (Exception $e) {
//   echo "❌ Erro: " . $e->getMessage() . "\n";
// }


function call_moodle_api(string $function, array $params, string $token, string $moodleUrl): mixed
{
  $url = $moodleUrl . '/webservice/rest/server.php?wstoken=' . $token .
    '&wsfunction=' . $function . '&moodlewsrestformat=json';

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => http_build_query($params),
  ]);

  $response = curl_exec($ch);
  if (!$response) throw new Exception("Erro CURL: " . curl_error($ch));
  curl_close($ch);

  $data = json_decode($response, true);
  if (isset($data['exception']))
    throw new Exception("Erro Moodle: {$data['message']} ({$data['errorcode']})");

  return $data;
}

//ammedina1954@gmail.com
//felipe.munhoz@gmail.com

// $params = [
//   'wstoken' => $token,
//   'wsfunction' => 'core_user_get_users_by_field',
//   'moodlewsrestformat' => 'json',
//   'field' => 'email',
//   'values[0]' => $email
// ];

// $ch = curl_init($moodleUrl);
// curl_setopt_array($ch, [
//   CURLOPT_RETURNTRANSFER => true,
//   CURLOPT_POST => true,
//   CURLOPT_POSTFIELDS => $params
// ]);

// $response = curl_exec($ch);
// curl_close($ch);

// $result = json_decode($response, true);
// print_r($result);
// try {
//   // 🔹 Dados do aluno vindos do seu BD
// $aluno = [
//   'username'     => 'raphael.pereira1',
//   'password'     => 'Senha@2025',
//   'firstname'    => 'Raphael',
//   'lastname'     => 'Pereira',
//   'email'        => 'raphaelpereiravalle2@gmail.com',
//   'city'         => 'Brasilia',
//   'country'      => 'BR',
//   'lang' => 'pt_br',
//   'description'  => 'Aluno da turma 2025',
//   'auth' => 'manual',
//   'preferences' => [
//     [
//       "type" => "auth_forcepasswordchange",
//       "value" => "0"
//     ]
//   ]
// ];

//   $resp = call_moodle_api('core_user_create_users', [
//     'users' => [$aluno]
//   ], $token, $moodleUrl);

//   $userId = $resp[0]['id'];
//   echo "Usuário criado com sucesso! ID: $userId\n";
// } catch (Exception $e) {
//   echo "❌ Erro: " . $e->getMessage();
// }


// $courseId = 23;

// try {
//   // Verificar se aluno já existe
//   $check = call_moodle_api('core_user_get_users_by_field', [
//     'field' => 'email',
//     'values' => [$aluno['email']]
//   ], $token, $moodleUrl);

//   if (!empty($check)) {
//     $userId = $check[0]['id'];
//     echo "Usuário já existe no Moodle (ID $userId)\n";
//   } else {
//     // Criar aluno
//     $resp = call_moodle_api('core_user_create_users', [
//       'users' => [$aluno]
//     ], $token, $moodleUrl);

//     $userId = $resp[0]['id'];
//     echo "Usuário criado com sucesso! ID: $userId\n";
//   }

//   // Matricular no curso
//   call_moodle_api('enrol_manual_enrol_users', [
//     'enrolments' => [
//       [
//         'roleid' => 5, // estudante
//         'userid' => $userId,
//         'courseid' => $courseId
//       ]
//     ]
//   ], $token, $moodleUrl);

//   //echo "✅ Matrícula realizada com sucesso no curso ID $courseId\n";
// } catch (Exception $e) {
//   echo "❌ Erro: " . $e->getMessage();
// }
